<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .user-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 15px;
        transition: all 0.3s;
        display: flex;
        align-items: center;
        gap: 20px;
    }

    .user-card:hover {
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
        transform: translateY(-2px);
    }

    .user-card.inactive {
        opacity: 0.6;
    }

    .user-avatar {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        object-fit: cover;
        border: 3px solid #f0f0f0;
    }

    .user-avatar-placeholder {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
        font-weight: bold;
    }

    .user-info {
        flex: 1;
    }

    .user-name {
        font-weight: 600;
        font-size: 16px;
        color: #333;
        margin-bottom: 5px;
    }

    .user-email {
        color: #666;
        font-size: 13px;
        margin-bottom: 8px;
    }

    .user-meta {
        display: flex;
        gap: 15px;
        flex-wrap: wrap;
    }

    .meta-badge {
        display: inline-flex;
        align-items: center;
        gap: 5px;
        padding: 3px 10px;
        border-radius: 4px;
        font-size: 12px;
    }

    .meta-badge i {
        font-size: 11px;
    }

    .role-badge {
        background: #e3f2fd;
        color: #1976d2;
    }

    .location-badge {
        background: #f3e5f5;
        color: #7b1fa2;
    }

    .employee-badge {
        background: #e8f5e9;
        color: #388e3c;
    }

    .user-actions {
        display: flex;
        gap: 8px;
    }

    .user-actions .btn {
        padding: 6px 12px;
        font-size: 13px;
    }

    .status-badge {
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-active {
        background: #d4edda;
        color: #155724;
    }

    .status-inactive {
        background: #f8d7da;
        color: #721c24;
    }

    .filter-card {
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 20px;
    }

    .stats-row {
        display: flex;
        gap: 20px;
        margin-bottom: 30px;
    }

    .stat-box {
        flex: 1;
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .stat-icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
    }

    .stat-content h3 {
        margin: 0;
        font-size: 28px;
        font-weight: 700;
        color: #333;
    }

    .stat-content p {
        margin: 0;
        font-size: 13px;
        color: #666;
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">User Management</h3>
                <p class="text-muted mb-0">Manage system users and their access permissions</p>
            </div>
            <?php if (has_permission('create-user')): ?>
            <a href="<?= base_url('settings/users/create') ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Create New User
            </a>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Statistics -->
<div class="stats-row">
    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <i class="fas fa-users"></i>
        </div>
        <div class="stat-content">
            <h3><?= count($users) ?></h3>
            <p>Total Users</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
            <i class="fas fa-user-check"></i>
        </div>
        <div class="stat-content">
            <h3><?= count(array_filter($users, fn($u) => $u['status'] == 'active')) ?></h3>
            <p>Active Users</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
            <i class="fas fa-user-times"></i>
        </div>
        <div class="stat-content">
            <h3><?= count(array_filter($users, fn($u) => $u['status'] == 'inactive')) ?></h3>
            <p>Inactive Users</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #ffa502 0%, #ff6348 100%);">
            <i class="fas fa-id-badge"></i>
        </div>
        <div class="stat-content">
            <h3><?= count(array_filter($users, fn($u) => !empty($u['employee_id']))) ?></h3>
            <p>Linked to Employees</p>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-card">
    <form method="get" action="<?= base_url('settings/users') ?>">
        <div class="row g-3">
            <div class="col-md-3">
                <label class="form-label small">Search</label>
                <input type="text" class="form-control" name="search" placeholder="Name, email, username..." value="<?= esc($filters['search'] ?? '') ?>">
            </div>
            <div class="col-md-2">
                <label class="form-label small">Role</label>
                <select class="form-select" name="role_id">
                    <option value="">All Roles</option>
                    <?php foreach ($roles as $role): ?>
                        <option value="<?= $role['id'] ?>" <?= ($filters['role_id'] == $role['id']) ? 'selected' : '' ?>>
                            <?= esc($role['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label small">Location</label>
                <select class="form-select" name="location_id">
                    <option value="">All Locations</option>
                    <?php foreach ($locations as $location): ?>
                        <option value="<?= $location['id'] ?>" <?= ($filters['location_id'] == $location['id']) ? 'selected' : '' ?>>
                            <?= esc($location['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label small">Status</label>
                <select class="form-select" name="is_active">
                    <option value="">All Status</option>
                    <option value="1" <?= ($filters['is_active'] === '1') ? 'selected' : '' ?>>Active</option>
                    <option value="0" <?= ($filters['is_active'] === '0') ? 'selected' : '' ?>>Inactive</option>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end gap-2">
                <button type="submit" class="btn btn-primary flex-grow-1">
                    <i class="fas fa-filter me-2"></i>Filter
                </button>
                <a href="<?= base_url('settings/users') ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-redo"></i>
                </a>
            </div>
        </div>
    </form>
</div>

<!-- Users List -->
<?php if (!empty($users)): ?>
    <div class="row">
        <div class="col-md-12">
            <?php foreach ($users as $user): ?>
            <div class="user-card <?= !$user['status'] ? 'inactive' : '' ?>" id="user-<?= $user['id'] ?>">
                <!-- Avatar -->
                <?php if (!empty($user['profile_photo'])): ?>
                    <img src="<?= base_url('uploads/users/' . $user['profile_photo']) ?>" alt="<?= esc($user['first_name']) ?>" class="user-avatar">
                <?php else: ?>
                    <div class="user-avatar-placeholder">
                        <?= strtoupper(substr($user['first_name'], 0, 1) . substr($user['last_name'], 0, 1)) ?>
                    </div>
                <?php endif; ?>

                <!-- User Info -->
                <div class="user-info">
                    <div class="user-name">
                        <?= esc($user['first_name'] . ' ' . $user['last_name']) ?>
                        <span class="status-badge status-<?= $user['status'] ? 'active' : 'inactive' ?>">
                            <?= $user['status'] ? 'Active' : 'Inactive' ?>
                        </span>
                    </div>
                    <div class="user-email">
                        <i class="fas fa-user me-1"></i><?= esc($user['username']) ?>
                        <?php if (!empty($user['email'])): ?>
                            <span class="ms-2"><i class="fas fa-envelope me-1"></i><?= esc($user['email']) ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="user-meta">
                        <?php if (!empty($user['role_name'])): ?>
                            <span class="meta-badge role-badge">
                                <i class="fas fa-user-tag"></i> <?= esc($user['role_name']) ?>
                            </span>
                        <?php endif; ?>
                        <?php if (!empty($user['location_name'])): ?>
                            <span class="meta-badge location-badge">
                                <i class="fas fa-map-marker-alt"></i> <?= esc($user['location_name']) ?>
                            </span>
                        <?php endif; ?>
                        <?php if (!empty($user['employee_number'])): ?>
                            <span class="meta-badge employee-badge">
                                <i class="fas fa-id-badge"></i> EMP# <?= esc($user['employee_number']) ?>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Actions -->
                <div class="user-actions">
                    <a href="<?= base_url('settings/users/view/' . $user['id']) ?>" class="btn btn-sm btn-outline-info" title="View Details">
                        <i class="fas fa-eye"></i>
                    </a>
                    <?php if (has_permission('edit-user')): ?>
                    <a href="<?= base_url('settings/users/edit/' . $user['id']) ?>" class="btn btn-sm btn-outline-primary" title="Edit">
                        <i class="fas fa-edit"></i>
                    </a>
                    <button class="btn btn-sm btn-outline-<?= $user['status'] ? 'warning' : 'success' ?>"
                            onclick="toggleUserStatus(<?= $user['id'] ?>)"
                            title="<?= $user['status'] ? 'Deactivate' : 'Activate' ?>">
                        <i class="fas fa-<?= $user['status'] ? 'pause' : 'play' ?>"></i>
                    </button>
                    <?php endif; ?>
                    <?php if (has_permission('delete-user') && $user['role_id'] != 1): ?>
                    <button class="btn btn-sm btn-outline-danger"
                            onclick="deleteUser(<?= $user['id'] ?>, '<?= esc($user['username']) ?>')"
                            title="Delete">
                        <i class="fas fa-trash"></i>
                    </button>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php else: ?>
    <div class="text-center py-5">
        <i class="fas fa-users fa-4x text-muted mb-3"></i>
        <h5>No Users Found</h5>
        <p class="text-muted">No users match your filter criteria</p>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function toggleUserStatus(userId) {
        if (!confirm('Are you sure you want to change this user status?')) {
            return;
        }

        fetch(`<?= base_url('settings/users/toggleStatus') ?>/${userId}`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to update user status');
        });
    }

    function deleteUser(userId, username) {
        if (!confirm(`Are you sure you want to delete the user "${username}"? This action cannot be undone.`)) {
            return;
        }

        fetch(`<?= base_url('settings/users/delete') ?>/${userId}`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('user-' + userId).remove();
                alert(data.message);
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to delete user');
        });
    }
</script>
<?= $this->endSection() ?>
