<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user-edit me-2"></i><?= esc($pageTitle) ?></h2>
    <a href="<?= base_url('settings/users') ?>" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Back to List
    </a>
</div>

<!-- Flash Messages -->
<?php if (session()->has('errors')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <strong>Please fix the following errors:</strong>
    <ul class="mb-0 mt-2">
        <?php foreach (session('errors') as $error): ?>
        <li><?= esc($error) ?></li>
        <?php endforeach; ?>
    </ul>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (session()->has('error')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i><?= session('error') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- User Form -->
<form action="<?= base_url('settings/users/update/' . $user['id']) ?>" method="post" enctype="multipart/form-data">
    <?= csrf_field() ?>

    <!-- Current Profile Photo -->
    <?php if (!empty($user['profile_photo'])): ?>
    <div class="table-card mb-4 text-center">
        <h5 class="mb-3">Current Profile Photo</h5>
        <img src="<?= base_url('uploads/users/' . $user['profile_photo']) ?>" alt="Profile Photo"
             class="rounded-circle" style="width: 120px; height: 120px; object-fit: cover;">
    </div>
    <?php endif; ?>

    <!-- Account Information -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-user-lock me-2"></i>Account Information</h5>
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="username" class="form-label">Username <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="username" name="username"
                       value="<?= old('username', $user['username']) ?>" required>
                <small class="form-text text-muted">Must be unique, alphanumeric with dashes/underscores allowed</small>
            </div>

            <div class="col-md-6 mb-3">
                <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
                <input type="email" class="form-control" id="email" name="email"
                       value="<?= old('email', $user['email']) ?>" required>
            </div>

            <?php if (!empty($user['employee_number'])): ?>
            <div class="col-md-12 mb-3">
                <div class="alert alert-info">
                    <i class="fas fa-link me-2"></i>
                    This user is linked to employee: <strong><?= esc($user['emp_first_name'] . ' ' . $user['emp_last_name']) ?></strong>
                    (<?= esc($user['employee_number']) ?>)
                </div>
            </div>
            <?php endif; ?>

            <div class="col-md-12 mb-3">
                <div class="alert alert-warning">
                    <i class="fas fa-info-circle me-2"></i>
                    Leave password fields blank to keep current password
                </div>
            </div>

            <div class="col-md-6 mb-3">
                <label for="password" class="form-label">New Password</label>
                <input type="password" class="form-control" id="password" name="password" minlength="6">
                <small class="form-text text-muted">Minimum 6 characters (leave blank to keep current)</small>
            </div>

            <div class="col-md-6 mb-3">
                <label for="password_confirm" class="form-label">Confirm New Password</label>
                <input type="password" class="form-control" id="password_confirm" name="password_confirm">
            </div>
        </div>
    </div>

    <!-- Personal Information -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-id-card me-2"></i>Personal Information</h5>
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="first_name" class="form-label">First Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="first_name" name="first_name"
                       value="<?= old('first_name', $user['first_name']) ?>" required>
            </div>

            <div class="col-md-6 mb-3">
                <label for="last_name" class="form-label">Last Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="last_name" name="last_name"
                       value="<?= old('last_name', $user['last_name']) ?>" required>
            </div>

            <div class="col-md-6 mb-3">
                <label for="phone" class="form-label">Phone Number</label>
                <input type="text" class="form-control" id="phone" name="phone"
                       value="<?= old('phone', $user['phone']) ?>">
            </div>

            <div class="col-md-6 mb-3">
                <label for="profile_photo" class="form-label">Change Profile Photo</label>
                <input type="file" class="form-control" id="profile_photo" name="profile_photo" accept="image/*">
                <small class="form-text text-muted">PNG, JPG, or GIF (Max 2MB) - Leave empty to keep current photo</small>
            </div>
        </div>
    </div>

    <!-- Role & Access -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-user-shield me-2"></i>Role & Access</h5>
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="role_id" class="form-label">Role <span class="text-danger">*</span></label>
                <select class="form-select" id="role_id" name="role_id" required>
                    <option value="">Select Role</option>
                    <?php foreach ($roles as $role): ?>
                        <option value="<?= $role['id'] ?>"
                                <?= old('role_id', $user['role_id']) == $role['id'] ? 'selected' : '' ?>>
                            <?= esc($role['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Determines user permissions</small>
            </div>

            <div class="col-md-6 mb-3">
                <label for="location_id" class="form-label">Location</label>
                <select class="form-select" id="location_id" name="location_id">
                    <option value="">Select Location</option>
                    <?php foreach ($locations as $location): ?>
                        <option value="<?= $location['id'] ?>"
                                <?= old('location_id', $user['location_id']) == $location['id'] ? 'selected' : '' ?>>
                            <?= esc($location['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-12 mb-3">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                           <?= old('is_active', $user['is_active']) == '1' ? 'checked' : '' ?>>
                    <label class="form-check-label" for="is_active">
                        Active - User can log in
                    </label>
                </div>
            </div>
        </div>
    </div>

    <!-- Additional Information -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-info-circle me-2"></i>Account Information</h5>
        <div class="row">
            <div class="col-md-6 mb-2">
                <strong>Created:</strong> <?= date('M d, Y h:i A', strtotime($user['created_at'])) ?>
            </div>
            <div class="col-md-6 mb-2">
                <strong>Last Updated:</strong> <?= date('M d, Y h:i A', strtotime($user['updated_at'])) ?>
            </div>
            <?php if (!empty($user['last_login'])): ?>
            <div class="col-md-6 mb-2">
                <strong>Last Login:</strong> <?= date('M d, Y h:i A', strtotime($user['last_login'])) ?>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Submit Buttons -->
    <div class="table-card">
        <div class="d-flex justify-content-end gap-2">
            <a href="<?= base_url('settings/users') ?>" class="btn btn-outline-secondary">
                <i class="fas fa-times me-2"></i>Cancel
            </a>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save me-2"></i>Update User
            </button>
        </div>
    </div>
</form>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
// Password match validation
document.querySelector('form').addEventListener('submit', function(e) {
    const password = document.getElementById('password').value;
    const passwordConfirm = document.getElementById('password_confirm').value;

    // Only validate if password is being changed
    if (password || passwordConfirm) {
        if (password !== passwordConfirm) {
            e.preventDefault();
            alert('Passwords do not match!');
            document.getElementById('password_confirm').focus();
        }
    }
});
</script>
<?= $this->endSection() ?>
