<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user-plus me-2"></i><?= esc($pageTitle) ?></h2>
    <a href="<?= base_url('settings/users') ?>" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Back to List
    </a>
</div>

<!-- Flash Messages -->
<?php if (session()->has('errors')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <strong>Please fix the following errors:</strong>
    <ul class="mb-0 mt-2">
        <?php foreach (session('errors') as $error): ?>
        <li><?= esc($error) ?></li>
        <?php endforeach; ?>
    </ul>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (session()->has('error')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i><?= session('error') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- User Form -->
<form action="<?= base_url('settings/users/store') ?>" method="post" enctype="multipart/form-data">
    <?= csrf_field() ?>

    <!-- Account Information -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-user-lock me-2"></i>Account Information</h5>
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="username" class="form-label">Username <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="username" name="username"
                       value="<?= old('username') ?>" required>
                <small class="form-text text-muted">Must be unique, alphanumeric with dashes/underscores allowed</small>
            </div>

            <div class="col-md-6 mb-3">
                <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
                <input type="email" class="form-control" id="email" name="email"
                       value="<?= old('email') ?>" required>
            </div>

            <div class="col-md-6 mb-3">
                <label for="password" class="form-label">Password <span class="text-danger">*</span></label>
                <input type="password" class="form-control" id="password" name="password" required minlength="6">
                <small class="form-text text-muted">Minimum 6 characters</small>
            </div>

            <div class="col-md-6 mb-3">
                <label for="password_confirm" class="form-label">Confirm Password <span class="text-danger">*</span></label>
                <input type="password" class="form-control" id="password_confirm" name="password_confirm" required>
            </div>
        </div>
    </div>

    <!-- Personal Information -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-id-card me-2"></i>Personal Information</h5>
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="first_name" class="form-label">First Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="first_name" name="first_name"
                       value="<?= old('first_name') ?>" required>
            </div>

            <div class="col-md-6 mb-3">
                <label for="last_name" class="form-label">Last Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="last_name" name="last_name"
                       value="<?= old('last_name') ?>" required>
            </div>

            <div class="col-md-6 mb-3">
                <label for="phone" class="form-label">Phone Number</label>
                <input type="text" class="form-control" id="phone" name="phone"
                       value="<?= old('phone') ?>">
            </div>

            <div class="col-md-6 mb-3">
                <label for="profile_photo" class="form-label">Profile Photo</label>
                <input type="file" class="form-control" id="profile_photo" name="profile_photo" accept="image/*">
                <small class="form-text text-muted">PNG, JPG, or GIF (Max 2MB)</small>
            </div>
        </div>
    </div>

    <!-- Link to Employee (Optional) -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-link me-2"></i>Link to Employee (Optional)</h5>
        <div class="row">
            <div class="col-md-12 mb-3">
                <label for="employee_id" class="form-label">Employee</label>
                <select class="form-select" id="employee_id" name="employee_id">
                    <option value="">None - Create standalone user</option>
                    <?php foreach ($employees as $employee): ?>
                        <option value="<?= $employee['id'] ?>"
                                data-first-name="<?= esc($employee['first_name']) ?>"
                                data-last-name="<?= esc($employee['last_name']) ?>"
                                data-email="<?= esc($employee['email']) ?>"
                                <?= old('employee_id') == $employee['id'] ? 'selected' : '' ?>>
                            <?= esc($employee['employee_id'] . ' - ' . $employee['first_name'] . ' ' . $employee['last_name']) ?>
                            <?php if ($employee['email']): ?>
                                (<?= esc($employee['email']) ?>)
                            <?php endif; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Select an employee to automatically populate their information</small>
            </div>
        </div>
    </div>

    <!-- Role & Access -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-user-shield me-2"></i>Role & Access</h5>
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="role_id" class="form-label">Role <span class="text-danger">*</span></label>
                <select class="form-select" id="role_id" name="role_id" required>
                    <option value="">Select Role</option>
                    <?php foreach ($roles as $role): ?>
                        <option value="<?= $role['id'] ?>" <?= old('role_id') == $role['id'] ? 'selected' : '' ?>>
                            <?= esc($role['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <small class="form-text text-muted">Determines user permissions</small>
            </div>

            <div class="col-md-6 mb-3">
                <label for="location_id" class="form-label">Location</label>
                <select class="form-select" id="location_id" name="location_id">
                    <option value="">Select Location</option>
                    <?php foreach ($locations as $location): ?>
                        <option value="<?= $location['id'] ?>" <?= old('location_id') == $location['id'] ? 'selected' : '' ?>>
                            <?= esc($location['name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-12 mb-3">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1"
                           <?= old('is_active', '1') == '1' ? 'checked' : '' ?>>
                    <label class="form-check-label" for="is_active">
                        Active - User can log in
                    </label>
                </div>
            </div>
        </div>
    </div>

    <!-- Submit Buttons -->
    <div class="table-card">
        <div class="d-flex justify-content-end gap-2">
            <a href="<?= base_url('settings/users') ?>" class="btn btn-outline-secondary">
                <i class="fas fa-times me-2"></i>Cancel
            </a>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save me-2"></i>Create User
            </button>
        </div>
    </div>
</form>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
// Auto-fill form when employee is selected
document.getElementById('employee_id').addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];

    if (this.value) {
        // Fill in personal information from employee
        document.getElementById('first_name').value = selectedOption.getAttribute('data-first-name') || '';
        document.getElementById('last_name').value = selectedOption.getAttribute('data-last-name') || '';
        document.getElementById('email').value = selectedOption.getAttribute('data-email') || '';

        // Generate username from employee name
        const firstName = selectedOption.getAttribute('data-first-name') || '';
        const lastName = selectedOption.getAttribute('data-last-name') || '';
        const username = (firstName + '.' + lastName).toLowerCase().replace(/[^a-z0-9.]/g, '');
        document.getElementById('username').value = username;
    }
});

// Password match validation
document.querySelector('form').addEventListener('submit', function(e) {
    const password = document.getElementById('password').value;
    const passwordConfirm = document.getElementById('password_confirm').value;

    if (password !== passwordConfirm) {
        e.preventDefault();
        alert('Passwords do not match!');
        document.getElementById('password_confirm').focus();
    }
});
</script>
<?= $this->endSection() ?>
