<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .role-card {
        background: white;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 20px;
        border-left: 4px solid #667eea;
        transition: all 0.3s;
        position: relative;
    }

    .role-card:hover {
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
        transform: translateY(-2px);
    }

    .role-card.inactive {
        opacity: 0.7;
        border-left-color: #ccc;
    }

    .role-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 15px;
    }

    .role-title {
        font-weight: 600;
        font-size: 18px;
        color: #333;
        margin-bottom: 5px;
    }

    .role-slug {
        font-family: 'Courier New', monospace;
        background: #f0f0f0;
        padding: 2px 8px;
        border-radius: 4px;
        font-size: 12px;
        color: #666;
    }

    .role-description {
        color: #666;
        margin-top: 10px;
        margin-bottom: 15px;
        line-height: 1.5;
    }

    .role-meta {
        display: flex;
        gap: 20px;
        margin-top: 15px;
        padding-top: 15px;
        border-top: 1px solid #f0f0f0;
    }

    .meta-item {
        display: flex;
        align-items: center;
        font-size: 13px;
        color: #666;
    }

    .meta-item i {
        margin-right: 5px;
        color: #999;
    }

    .meta-item strong {
        color: #333;
        margin-left: 5px;
    }

    .role-actions {
        display: flex;
        gap: 8px;
    }

    .role-actions .btn {
        padding: 6px 12px;
        font-size: 13px;
    }

    .status-badge {
        position: absolute;
        top: 20px;
        right: 20px;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-active {
        background: #d4edda;
        color: #155724;
    }

    .status-inactive {
        background: #f8d7da;
        color: #721c24;
    }

    .system-role-badge {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 2px 8px;
        border-radius: 4px;
        font-size: 10px;
        font-weight: 600;
        text-transform: uppercase;
        margin-left: 8px;
    }

    .stats-row {
        display: flex;
        gap: 20px;
        margin-bottom: 30px;
    }

    .stat-box {
        flex: 1;
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .stat-icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
    }

    .stat-content h3 {
        margin: 0;
        font-size: 28px;
        font-weight: 700;
        color: #333;
    }

    .stat-content p {
        margin: 0;
        font-size: 13px;
        color: #666;
    }

    .empty-state {
        text-align: center;
        padding: 80px 20px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .empty-state i {
        font-size: 80px;
        color: #e0e0e0;
        margin-bottom: 20px;
    }

    .permission-preview {
        display: flex;
        flex-wrap: wrap;
        gap: 5px;
        margin-top: 10px;
    }

    .permission-tag {
        background: #e3f2fd;
        color: #1976d2;
        padding: 3px 8px;
        border-radius: 4px;
        font-size: 11px;
    }

    .permission-more {
        background: #f0f0f0;
        color: #666;
        padding: 3px 8px;
        border-radius: 4px;
        font-size: 11px;
        cursor: pointer;
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">Roles & Permissions</h3>
                <p class="text-muted mb-0">Manage user roles and assign permissions to control access</p>
            </div>
            <a href="<?= base_url('settings/roles/create') ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Create New Role
            </a>
        </div>
    </div>
</div>

<!-- Statistics -->
<div class="stats-row">
    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <i class="fas fa-user-tag"></i>
        </div>
        <div class="stat-content">
            <h3><?= count($roles) ?></h3>
            <p>Total Roles</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-content">
            <h3><?= count(array_filter($roles, fn($r) => $r['is_active'] == 1)) ?></h3>
            <p>Active Roles</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
            <i class="fas fa-users"></i>
        </div>
        <div class="stat-content">
            <h3><?= array_sum(array_column($roles, 'user_count')) ?></h3>
            <p>Users Assigned</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #ffa502 0%, #ff6348 100%);">
            <i class="fas fa-shield-alt"></i>
        </div>
        <div class="stat-content">
            <h3><?= array_sum(array_column($roles, 'permission_count')) ?></h3>
            <p>Total Permissions</p>
        </div>
    </div>
</div>

<!-- Roles List -->
<?php if (!empty($roles)): ?>
    <div class="row">
        <div class="col-md-12">
            <?php foreach ($roles as $role): ?>
            <div class="role-card <?= !$role['is_active'] ? 'inactive' : '' ?>" id="role-<?= $role['id'] ?>">
                <span class="status-badge status-<?= $role['is_active'] ? 'active' : 'inactive' ?>">
                    <?= $role['is_active'] ? 'Active' : 'Inactive' ?>
                </span>

                <div class="role-header">
                    <div>
                        <div class="role-title">
                            <?= esc($role['name']) ?>
                            <?php if (in_array($role['slug'], ['super_admin', 'admin'])): ?>
                                <span class="system-role-badge">System Role</span>
                            <?php endif; ?>
                        </div>
                        <span class="role-slug"><?= esc($role['slug']) ?></span>
                    </div>
                </div>

                <?php if ($role['description']): ?>
                <div class="role-description">
                    <?= esc($role['description']) ?>
                </div>
                <?php endif; ?>

                <div class="role-meta">
                    <div class="meta-item">
                        <i class="fas fa-users"></i>
                        <strong><?= $role['user_count'] ?></strong> user(s)
                    </div>
                    <div class="meta-item">
                        <i class="fas fa-shield-alt"></i>
                        <strong><?= $role['permission_count'] ?></strong> permission(s)
                    </div>
                    <div class="meta-item">
                        <i class="fas fa-calendar"></i>
                        Created <?= date('M d, Y', strtotime($role['created_at'])) ?>
                    </div>
                </div>

                <div class="mt-3">
                    <div class="role-actions">
                        <button class="btn btn-sm btn-outline-info" onclick="viewRole(<?= $role['id'] ?>)">
                            <i class="fas fa-eye me-1"></i>View Details
                        </button>
                        <a href="<?= base_url('settings/roles/edit/' . $role['id']) ?>" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-edit me-1"></i>Edit
                        </a>
                        <button class="btn btn-sm btn-outline-<?= $role['is_active'] ? 'warning' : 'success' ?>"
                                onclick="toggleRoleStatus(<?= $role['id'] ?>)">
                            <i class="fas fa-<?= $role['is_active'] ? 'pause' : 'play' ?> me-1"></i>
                            <?= $role['is_active'] ? 'Deactivate' : 'Activate' ?>
                        </button>
                        <?php if (!in_array($role['slug'], ['super_admin', 'admin'])): ?>
                        <button class="btn btn-sm btn-outline-danger" onclick="deleteRole(<?= $role['id'] ?>, '<?= esc($role['name']) ?>')">
                            <i class="fas fa-trash me-1"></i>Delete
                        </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php else: ?>
    <div class="empty-state">
        <i class="fas fa-user-tag"></i>
        <h5>No Roles Found</h5>
        <p>You haven't created any roles yet. Create your first role to get started.</p>
        <a href="<?= base_url('settings/roles/create') ?>" class="btn btn-primary btn-lg">
            <i class="fas fa-plus me-2"></i>Create First Role
        </a>
    </div>
<?php endif; ?>

<!-- View Role Modal -->
<div class="modal fade" id="viewRoleModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                <h5 class="modal-title">
                    <i class="fas fa-user-tag me-2"></i>Role Details
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" style="filter: brightness(0) invert(1);"></button>
            </div>
            <div class="modal-body" id="roleDetailsContent">
                <div class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function viewRole(roleId) {
        const modal = new bootstrap.Modal(document.getElementById('viewRoleModal'));
        modal.show();

        fetch(`<?= base_url('settings/roles/view') ?>/${roleId}`)
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    displayRoleDetails(data.role);
                } else {
                    document.getElementById('roleDetailsContent').innerHTML = `
                        <div class="alert alert-danger">
                            <i class="fas fa-exclamation-circle me-2"></i>${data.message}
                        </div>
                    `;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                document.getElementById('roleDetailsContent').innerHTML = `
                    <div class="alert alert-danger">
                        <i class="fas fa-exclamation-circle me-2"></i>Failed to load role details
                    </div>
                `;
            });
    }

    function displayRoleDetails(role) {
        let permissionsHtml = '';
        if (role.permissions && role.permissions.length > 0) {
            // Group permissions by module
            const groupedPermissions = {};
            role.permissions.forEach(perm => {
                if (!groupedPermissions[perm.module]) {
                    groupedPermissions[perm.module] = [];
                }
                groupedPermissions[perm.module].push(perm);
            });

            permissionsHtml = '<div class="row">';
            Object.keys(groupedPermissions).forEach(module => {
                permissionsHtml += `
                    <div class="col-md-6 mb-3">
                        <h6 class="text-primary mb-2"><i class="fas fa-folder me-2"></i>${module}</h6>
                        <ul class="list-unstyled ms-3">
                `;
                groupedPermissions[module].forEach(perm => {
                    permissionsHtml += `
                        <li class="mb-1">
                            <i class="fas fa-check-circle text-success me-2"></i>${perm.name}
                        </li>
                    `;
                });
                permissionsHtml += `
                        </ul>
                    </div>
                `;
            });
            permissionsHtml += '</div>';
        } else {
            permissionsHtml = '<p class="text-muted">No permissions assigned to this role.</p>';
        }

        const statusBadge = role.is_active
            ? '<span class="badge bg-success">Active</span>'
            : '<span class="badge bg-danger">Inactive</span>';

        document.getElementById('roleDetailsContent').innerHTML = `
            <div class="mb-4">
                <h4>${role.name} ${statusBadge}</h4>
                <p class="text-muted mb-2"><code>${role.slug}</code></p>
                <p>${role.description || 'No description provided'}</p>
            </div>

            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="text-center p-3 bg-light rounded">
                        <i class="fas fa-users fa-2x text-primary mb-2"></i>
                        <h5>${role.user_count}</h5>
                        <small class="text-muted">Users</small>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="text-center p-3 bg-light rounded">
                        <i class="fas fa-shield-alt fa-2x text-success mb-2"></i>
                        <h5>${role.permissions.length}</h5>
                        <small class="text-muted">Permissions</small>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="text-center p-3 bg-light rounded">
                        <i class="fas fa-calendar fa-2x text-info mb-2"></i>
                        <h5>${new Date(role.created_at).toLocaleDateString()}</h5>
                        <small class="text-muted">Created</small>
                    </div>
                </div>
            </div>

            <h5 class="mb-3">Permissions</h5>
            ${permissionsHtml}

            <div class="mt-4 text-end">
                <a href="<?= base_url('settings/roles/edit') ?>/${role.employee_id}" class="btn btn-primary">
                    <i class="fas fa-edit me-2"></i>Edit Role
                </a>
            </div>
        `;
    }

    function toggleRoleStatus(roleId) {
        if (!confirm('Are you sure you want to change this role status?')) {
            return;
        }

        fetch(`<?= base_url('settings/roles/toggleStatus') ?>/${roleId}`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to update role status');
        });
    }

    function deleteRole(roleId, roleName) {
        if (!confirm(`Are you sure you want to delete the role "${roleName}"? This action cannot be undone.`)) {
            return;
        }

        fetch(`<?= base_url('settings/roles/delete') ?>/${roleId}`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('role-' + roleId).remove();
                alert(data.message);
                location.reload();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to delete role');
        });
    }
</script>
<?= $this->endSection() ?>
