<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .location-card {
        background: white;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 20px;
        border-left: 4px solid #11998e;
        transition: all 0.3s;
        position: relative;
    }

    .location-card:hover {
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
        transform: translateY(-2px);
    }

    .location-card.inactive {
        opacity: 0.7;
        border-left-color: #ccc;
    }

    .location-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 15px;
    }

    .location-title {
        font-weight: 600;
        font-size: 18px;
        color: #333;
        margin-bottom: 5px;
    }

    .location-code {
        font-family: 'Courier New', monospace;
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        color: white;
        padding: 3px 10px;
        border-radius: 4px;
        font-size: 12px;
        font-weight: 600;
        display: inline-block;
    }

    .location-address {
        color: #666;
        margin-top: 10px;
        line-height: 1.6;
        display: flex;
        align-items: start;
    }

    .location-address i {
        margin-right: 8px;
        margin-top: 3px;
        color: #11998e;
    }

    .location-meta {
        display: flex;
        gap: 20px;
        margin-top: 15px;
        padding-top: 15px;
        border-top: 1px solid #f0f0f0;
        flex-wrap: wrap;
    }

    .meta-item {
        display: flex;
        align-items: center;
        font-size: 13px;
        color: #666;
    }

    .meta-item i {
        margin-right: 5px;
        color: #999;
    }

    .meta-item strong {
        color: #333;
        margin-left: 5px;
    }

    .location-actions {
        display: flex;
        gap: 8px;
        margin-top: 15px;
    }

    .location-actions .btn {
        padding: 6px 12px;
        font-size: 13px;
    }

    .status-badge {
        position: absolute;
        top: 20px;
        right: 20px;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-active {
        background: #d4edda;
        color: #155724;
    }

    .status-inactive {
        background: #f8d7da;
        color: #721c24;
    }

    .stats-row {
        display: flex;
        gap: 20px;
        margin-bottom: 30px;
    }

    .stat-box {
        flex: 1;
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .stat-icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
    }

    .stat-content h3 {
        margin: 0;
        font-size: 28px;
        font-weight: 700;
        color: #333;
    }

    .stat-content p {
        margin: 0;
        font-size: 13px;
        color: #666;
    }

    .empty-state {
        text-align: center;
        padding: 80px 20px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .empty-state i {
        font-size: 80px;
        color: #e0e0e0;
        margin-bottom: 20px;
    }

    .contact-info {
        display: flex;
        gap: 15px;
        margin-top: 10px;
        flex-wrap: wrap;
    }

    .contact-item {
        font-size: 13px;
        color: #666;
        display: flex;
        align-items: center;
    }

    .contact-item i {
        margin-right: 5px;
        color: #11998e;
    }

    .map-link {
        color: #11998e;
        text-decoration: none;
        font-size: 13px;
    }

    .map-link:hover {
        text-decoration: underline;
    }

    .location-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(450px, 1fr));
        gap: 20px;
    }

    @media (max-width: 768px) {
        .location-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">Locations</h3>
                <p class="text-muted mb-0">Manage office locations and branches</p>
            </div>
            <a href="<?= base_url('settings/locations/create') ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Add New Location
            </a>
        </div>
    </div>
</div>

<!-- Statistics -->
<div class="stats-row">
    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
            <i class="fas fa-map-marker-alt"></i>
        </div>
        <div class="stat-content">
            <h3><?= count($locations) ?></h3>
            <p>Total Locations</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-content">
            <h3><?= count(array_filter($locations, fn($l) => $l['is_active'] == 1)) ?></h3>
            <p>Active Locations</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
            <i class="fas fa-users"></i>
        </div>
        <div class="stat-content">
            <h3><?= array_sum(array_column($locations, 'employee_count')) ?></h3>
            <p>Total Employees</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #ffa502 0%, #ff6348 100%);">
            <i class="fas fa-clock"></i>
        </div>
        <div class="stat-content">
            <h3><?= array_sum(array_column($locations, 'today_attendance')) ?></h3>
            <p>Today's Attendance</p>
        </div>
    </div>
</div>

<!-- Locations List -->
<?php if (!empty($locations)): ?>
    <div class="location-grid">
        <?php foreach ($locations as $location): ?>
        <div class="location-card <?= !$location['is_active'] ? 'inactive' : '' ?>" id="location-<?= $location['id'] ?>">
            <span class="status-badge status-<?= $location['is_active'] ? 'active' : 'inactive' ?>">
                <?= $location['is_active'] ? 'Active' : 'Inactive' ?>
            </span>

            <div class="location-header">
                <div>
                    <div class="location-title">
                        <i class="fas fa-map-marker-alt me-2" style="color: #11998e;"></i>
                        <?= esc($location['name']) ?>
                    </div>
                    <span class="location-code"><?= esc($location['code']) ?></span>
                </div>
            </div>

            <?php if ($location['address'] || $location['city'] || $location['province']): ?>
            <div class="location-address">
                <i class="fas fa-home"></i>
                <div>
                    <?php if ($location['address']): ?>
                        <?= esc($location['address']) ?><br>
                    <?php endif; ?>
                    <?php if ($location['city'] || $location['province']): ?>
                        <?= esc($location['city']) ?><?= $location['city'] && $location['province'] ? ', ' : '' ?><?= esc($location['province']) ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if ($location['contact_number'] || $location['email']): ?>
            <div class="contact-info">
                <?php if ($location['contact_number']): ?>
                <div class="contact-item">
                    <i class="fas fa-phone"></i>
                    <?= esc($location['contact_number']) ?>
                </div>
                <?php endif; ?>
                <?php if ($location['email']): ?>
                <div class="contact-item">
                    <i class="fas fa-envelope"></i>
                    <?= esc($location['email']) ?>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <div class="location-meta">
                <div class="meta-item">
                    <i class="fas fa-users"></i>
                    <strong><?= $location['employee_count'] ?></strong> employee(s)
                </div>
                <div class="meta-item">
                    <i class="fas fa-clock"></i>
                    <strong><?= $location['today_attendance'] ?></strong> present today
                </div>
                <?php if ($location['timezone']): ?>
                <div class="meta-item">
                    <i class="fas fa-globe"></i>
                    <?= esc($location['timezone']) ?>
                </div>
                <?php endif; ?>
                <?php if ($location['latitude'] && $location['longitude']): ?>
                <div class="meta-item">
                    <i class="fas fa-map-pin"></i>
                    <a href="https://www.google.com/maps?q=<?= $location['latitude'] ?>,<?= $location['longitude'] ?>"
                       target="_blank" class="map-link">
                        View on Map
                    </a>
                </div>
                <?php endif; ?>
            </div>

            <div class="location-actions">
                <a href="<?= base_url('settings/locations/edit/' . $location['id']) ?>" class="btn btn-sm btn-outline-primary">
                    <i class="fas fa-edit me-1"></i>Edit
                </a>
                <button class="btn btn-sm btn-outline-<?= $location['is_active'] ? 'warning' : 'success' ?>"
                        onclick="toggleLocationStatus(<?= $location['id'] ?>)">
                    <i class="fas fa-<?= $location['is_active'] ? 'pause' : 'play' ?> me-1"></i>
                    <?= $location['is_active'] ? 'Deactivate' : 'Activate' ?>
                </button>
                <button class="btn btn-sm btn-outline-danger" onclick="deleteLocation(<?= $location['id'] ?>, '<?= esc($location['name']) ?>')">
                    <i class="fas fa-trash me-1"></i>Delete
                </button>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
<?php else: ?>
    <div class="empty-state">
        <i class="fas fa-map-marker-alt"></i>
        <h5>No Locations Found</h5>
        <p>You haven't added any locations yet. Create your first location to get started.</p>
        <a href="<?= base_url('settings/locations/create') ?>" class="btn btn-primary btn-lg">
            <i class="fas fa-plus me-2"></i>Add First Location
        </a>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function toggleLocationStatus(locationId) {
        if (!confirm('Are you sure you want to change this location status?')) {
            return;
        }

        fetch(`<?= base_url('settings/locations/toggleStatus') ?>/${locationId}`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to update location status');
        });
    }

    function deleteLocation(locationId, locationName) {
        if (!confirm(`Are you sure you want to delete the location "${locationName}"? This action cannot be undone.`)) {
            return;
        }

        fetch(`<?= base_url('settings/locations/delete') ?>/${locationId}`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('location-' + locationId).remove();
                alert(data.message);
                location.reload();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to delete location');
        });
    }
</script>
<?= $this->endSection() ?>
