<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .department-card {
        background: white;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 20px;
        border-left: 4px solid #667eea;
        transition: all 0.3s;
        position: relative;
    }

    .department-card:hover {
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.12);
        transform: translateY(-2px);
    }

    .department-card.inactive {
        opacity: 0.7;
        border-left-color: #ccc;
    }

    .department-header {
        display: flex;
        justify-content: space-between;
        align-items: start;
        margin-bottom: 15px;
    }

    .department-title {
        font-weight: 600;
        font-size: 18px;
        color: #333;
        margin-bottom: 5px;
    }

    .department-code {
        font-family: 'Courier New', monospace;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 3px 10px;
        border-radius: 4px;
        font-size: 12px;
        font-weight: 600;
        display: inline-block;
    }

    .department-description {
        color: #666;
        margin-top: 10px;
        line-height: 1.6;
    }

    .department-head {
        background: #f8f9fa;
        border-radius: 8px;
        padding: 12px 15px;
        margin-top: 15px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .department-head i {
        color: #667eea;
        font-size: 18px;
    }

    .department-head .head-info {
        flex-grow: 1;
    }

    .department-head .head-name {
        font-weight: 600;
        color: #333;
        margin: 0;
    }

    .department-head .head-code {
        font-size: 12px;
        color: #666;
        font-family: 'Courier New', monospace;
    }

    .department-meta {
        display: flex;
        gap: 20px;
        margin-top: 15px;
        padding-top: 15px;
        border-top: 1px solid #f0f0f0;
        flex-wrap: wrap;
    }

    .meta-item {
        display: flex;
        align-items: center;
        font-size: 13px;
        color: #666;
    }

    .meta-item i {
        margin-right: 5px;
        color: #999;
    }

    .meta-item strong {
        color: #333;
        margin-left: 5px;
    }

    .department-actions {
        display: flex;
        gap: 8px;
        margin-top: 15px;
    }

    .department-actions .btn {
        padding: 6px 12px;
        font-size: 13px;
    }

    .status-badge {
        position: absolute;
        top: 20px;
        right: 20px;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-active {
        background: #d4edda;
        color: #155724;
    }

    .status-inactive {
        background: #f8d7da;
        color: #721c24;
    }

    .stats-row {
        display: flex;
        gap: 20px;
        margin-bottom: 30px;
    }

    .stat-box {
        flex: 1;
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .stat-icon {
        width: 50px;
        height: 50px;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
    }

    .stat-content h3 {
        margin: 0;
        font-size: 28px;
        font-weight: 700;
        color: #333;
    }

    .stat-content p {
        margin: 0;
        font-size: 13px;
        color: #666;
    }

    .empty-state {
        text-align: center;
        padding: 80px 20px;
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .empty-state i {
        font-size: 80px;
        color: #e0e0e0;
        margin-bottom: 20px;
    }

    .department-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(450px, 1fr));
        gap: 20px;
    }

    @media (max-width: 768px) {
        .department-grid {
            grid-template-columns: 1fr;
        }
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">Departments</h3>
                <p class="text-muted mb-0">Manage organizational departments and divisions</p>
            </div>
            <a href="<?= base_url('settings/departments/create') ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Add New Department
            </a>
        </div>
    </div>
</div>

<!-- Statistics -->
<div class="stats-row">
    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <i class="fas fa-building"></i>
        </div>
        <div class="stat-content">
            <h3><?= count($departments) ?></h3>
            <p>Total Departments</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-content">
            <h3><?= count(array_filter($departments, fn($d) => $d['is_active'] == 1)) ?></h3>
            <p>Active Departments</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
            <i class="fas fa-users"></i>
        </div>
        <div class="stat-content">
            <h3><?= array_sum(array_column($departments, 'employee_count')) ?></h3>
            <p>Total Employees</p>
        </div>
    </div>

    <div class="stat-box">
        <div class="stat-icon" style="background: linear-gradient(135deg, #ffa502 0%, #ff6348 100%);">
            <i class="fas fa-user-tie"></i>
        </div>
        <div class="stat-content">
            <h3><?= count(array_filter($departments, fn($d) => !empty($d['head_employee_id']))) ?></h3>
            <p>With Department Heads</p>
        </div>
    </div>
</div>

<!-- Departments List -->
<?php if (!empty($departments)): ?>
    <div class="department-grid">
        <?php foreach ($departments as $department): ?>
        <div class="department-card <?= !$department['is_active'] ? 'inactive' : '' ?>" id="department-<?= $department['id'] ?>">
            <span class="status-badge status-<?= $department['is_active'] ? 'active' : 'inactive' ?>">
                <?= $department['is_active'] ? 'Active' : 'Inactive' ?>
            </span>

            <div class="department-header">
                <div>
                    <div class="department-title">
                        <i class="fas fa-building me-2" style="color: #667eea;"></i>
                        <?= esc($department['name']) ?>
                    </div>
                    <span class="department-code"><?= esc($department['code']) ?></span>
                </div>
            </div>

            <?php if ($department['description']): ?>
            <div class="department-description">
                <?= esc($department['description']) ?>
            </div>
            <?php endif; ?>

            <?php if ($department['head_employee_id']): ?>
            <div class="department-head">
                <i class="fas fa-user-tie"></i>
                <div class="head-info">
                    <div class="head-name"><?= esc($department['head_name']) ?></div>
                    <div class="head-code">Department Head • <?= esc($department['head_employee_code']) ?></div>
                </div>
            </div>
            <?php endif; ?>

            <div class="department-meta">
                <div class="meta-item">
                    <i class="fas fa-users"></i>
                    <strong><?= $department['employee_count'] ?></strong> employee(s)
                </div>
                <div class="meta-item">
                    <i class="fas fa-clock"></i>
                    <strong><?= $department['today_attendance'] ?></strong> present today
                </div>
                <div class="meta-item">
                    <i class="fas fa-calendar"></i>
                    Created <?= date('M d, Y', strtotime($department['created_at'])) ?>
                </div>
            </div>

            <div class="department-actions">
                <a href="<?= base_url('settings/departments/edit/' . $department['id']) ?>" class="btn btn-sm btn-outline-primary">
                    <i class="fas fa-edit me-1"></i>Edit
                </a>
                <button class="btn btn-sm btn-outline-<?= $department['is_active'] ? 'warning' : 'success' ?>"
                        onclick="toggleDepartmentStatus(<?= $department['id'] ?>)">
                    <i class="fas fa-<?= $department['is_active'] ? 'pause' : 'play' ?> me-1"></i>
                    <?= $department['is_active'] ? 'Deactivate' : 'Activate' ?>
                </button>
                <button class="btn btn-sm btn-outline-danger" onclick="deleteDepartment(<?= $department['id'] ?>, '<?= esc($department['name']) ?>')">
                    <i class="fas fa-trash me-1"></i>Delete
                </button>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
<?php else: ?>
    <div class="empty-state">
        <i class="fas fa-building"></i>
        <h5>No Departments Found</h5>
        <p>You haven't created any departments yet. Create your first department to get started.</p>
        <a href="<?= base_url('settings/departments/create') ?>" class="btn btn-primary btn-lg">
            <i class="fas fa-plus me-2"></i>Add First Department
        </a>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function toggleDepartmentStatus(departmentId) {
        if (!confirm('Are you sure you want to change this department status?')) {
            return;
        }

        fetch(`<?= base_url('settings/departments/toggleStatus') ?>/${departmentId}`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to update department status');
        });
    }

    function deleteDepartment(departmentId, departmentName) {
        if (!confirm(`Are you sure you want to delete the department "${departmentName}"? This action cannot be undone.`)) {
            return;
        }

        fetch(`<?= base_url('settings/departments/delete') ?>/${departmentId}`, {
            method: 'POST',
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                document.getElementById('department-' + departmentId).remove();
                alert(data.message);
                location.reload();
            } else {
                alert(data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Failed to delete department');
        });
    }
</script>
<?= $this->endSection() ?>
