<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .form-card {
        background: white;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 20px;
    }

    .form-card h5 {
        font-weight: 600;
        margin-bottom: 20px;
        color: #333;
        display: flex;
        align-items: center;
    }

    .form-card h5 i {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        margin-right: 15px;
    }

    .info-box {
        background: #e8f5e9;
        border-left: 4px solid #4caf50;
        padding: 15px;
        border-radius: 8px;
        margin-bottom: 20px;
    }

    .info-box i {
        color: #4caf50;
        margin-right: 10px;
    }

    .sticky-footer {
        position: sticky;
        bottom: 0;
        background: white;
        padding: 20px 30px;
        box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.08);
        border-radius: 12px;
        margin-top: 20px;
    }

    .required-note {
        color: #dc3545;
        font-size: 13px;
        margin-bottom: 20px;
    }

    .helper-text {
        display: block;
        margin-top: 5px;
        font-size: 12px;
        color: #666;
    }

    .select2-container {
        width: 100% !important;
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">Create New Department</h3>
                <p class="text-muted mb-0">Add a new organizational department or division</p>
            </div>
            <a href="<?= base_url('settings/departments') ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to Departments
            </a>
        </div>
    </div>
</div>

<!-- Info Box -->
<div class="info-box">
    <i class="fas fa-info-circle fa-lg"></i>
    <strong>Department Information:</strong> Departments help organize employees by their functional roles or divisions within your organization.
</div>

<form action="<?= base_url('settings/departments/store') ?>" method="POST" id="departmentForm">
    <?= csrf_field() ?>

    <!-- Basic Information -->
    <div class="form-card">
        <h5>
            <i class="fas fa-info-circle"></i>
            Basic Information
        </h5>

        <p class="required-note"><i class="fas fa-asterisk"></i> Required fields</p>

        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Department Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control <?= isset($errors['name']) ? 'is-invalid' : '' ?>"
                       name="name" value="<?= old('name') ?>" required
                       placeholder="e.g., Human Resources, IT Department">
                <?php if (isset($errors['name'])): ?>
                    <div class="invalid-feedback"><?= $errors['name'] ?></div>
                <?php endif; ?>
                <small class="helper-text">A descriptive name for the department</small>
            </div>

            <div class="col-md-6">
                <label class="form-label">Department Code <span class="text-danger">*</span></label>
                <input type="text" class="form-control <?= isset($errors['code']) ? 'is-invalid' : '' ?>"
                       name="code" value="<?= old('code') ?>" required
                       placeholder="e.g., HR, IT"
                       style="text-transform: uppercase;">
                <?php if (isset($errors['code'])): ?>
                    <div class="invalid-feedback"><?= $errors['code'] ?></div>
                <?php endif; ?>
                <small class="helper-text">Unique code (uppercase, no spaces)</small>
            </div>

            <div class="col-md-12">
                <label class="form-label">Description</label>
                <textarea class="form-control <?= isset($errors['description']) ? 'is-invalid' : '' ?>"
                          name="description" rows="3"
                          placeholder="Brief description of the department's role and responsibilities"><?= old('description') ?></textarea>
                <?php if (isset($errors['description'])): ?>
                    <div class="invalid-feedback"><?= $errors['description'] ?></div>
                <?php endif; ?>
                <small class="helper-text">Optional description of the department</small>
            </div>

            <div class="col-md-12">
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="is_active" id="isActive"
                           <?= old('is_active', '1') ? 'checked' : '' ?> value="1">
                    <label class="form-check-label" for="isActive">
                        <strong>Active Department</strong>
                        <small class="d-block text-muted">Employees can be assigned to this department</small>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <!-- Department Head -->
    <div class="form-card">
        <h5>
            <i class="fas fa-user-tie"></i>
            Department Head
        </h5>

        <p class="text-muted mb-3">
            <small>
                <i class="fas fa-info-circle me-1"></i>
                Optional: Assign an employee as the head or manager of this department.
            </small>
        </p>

        <div class="row g-3">
            <div class="col-md-12">
                <label class="form-label">Select Department Head</label>
                <select class="form-select <?= isset($errors['head_employee_id']) ? 'is-invalid' : '' ?>"
                        name="head_employee_id" id="headEmployeeSelect">
                    <option value="">No Department Head (Optional)</option>
                    <?php foreach ($employees as $employee): ?>
                        <option value="<?= $employee['employee_id'] ?>"
                                <?= old('head_employee_id') == $employee['employee_id'] ? 'selected' : '' ?>>
                            <?= esc($employee['employee_id']) ?> - <?= esc($employee['full_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <?php if (isset($errors['head_employee_id'])): ?>
                    <div class="invalid-feedback"><?= $errors['head_employee_id'] ?></div>
                <?php endif; ?>
                <small class="helper-text">Search by employee ID or name</small>
            </div>
        </div>
    </div>

    <!-- Submit Footer -->
    <div class="sticky-footer">
        <div class="d-flex justify-content-end align-items-center">
            <a href="<?= base_url('settings/departments') ?>" class="btn btn-outline-secondary me-2">
                <i class="fas fa-times me-2"></i>Cancel
            </a>
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-save me-2"></i>Create Department
            </button>
        </div>
    </div>
</form>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Auto-generate code from name
    document.querySelector('input[name="name"]').addEventListener('input', function(e) {
        const code = e.target.value
            .toUpperCase()
            .replace(/[^A-Z0-9]+/g, '')
            .substring(0, 10);
        document.querySelector('input[name="code"]').value = code;
    });

    // Force uppercase for code
    document.querySelector('input[name="code"]').addEventListener('input', function(e) {
        e.target.value = e.target.value.toUpperCase();
    });

    // Enhanced select for employee search
    document.addEventListener('DOMContentLoaded', function() {
        const select = document.getElementById('headEmployeeSelect');

        // Add search functionality
        select.addEventListener('focus', function() {
            this.size = Math.min(10, this.options.length);
        });

        select.addEventListener('blur', function() {
            this.size = 1;
        });

        select.addEventListener('change', function() {
            this.size = 1;
            this.blur();
        });
    });
</script>
<?= $this->endSection() ?>
