<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .filter-card {
        background: white;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 30px;
    }

    .filter-card h5 {
        font-weight: 600;
        margin-bottom: 20px;
    }

    .report-type-selector {
        display: flex;
        gap: 15px;
        margin-bottom: 25px;
    }

    .report-type-btn {
        flex: 1;
        padding: 15px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        background: white;
        cursor: pointer;
        transition: all 0.3s;
        text-align: center;
    }

    .report-type-btn:hover {
        border-color: #11998e;
        background: #f8f9fa;
    }

    .report-type-btn.active {
        border-color: #11998e;
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        color: white;
    }

    .report-type-btn i {
        font-size: 24px;
        display: block;
        margin-bottom: 8px;
    }

    .report-type-btn span {
        font-weight: 600;
        font-size: 14px;
    }

    .results-card {
        background: white;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .results-card h5 {
        font-weight: 600;
        margin-bottom: 20px;
    }

    .status-badge {
        padding: 4px 10px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .status-approved {
        background: #d4edda;
        color: #155724;
    }

    .status-pending {
        background: #fff3cd;
        color: #856404;
    }

    .status-rejected {
        background: #f8d7da;
        color: #721c24;
    }

    .export-buttons {
        display: flex;
        gap: 10px;
        margin-bottom: 20px;
    }

    .no-data {
        text-align: center;
        padding: 60px 20px;
        color: #999;
    }

    .no-data i {
        font-size: 64px;
        margin-bottom: 20px;
        opacity: 0.3;
    }

    .balance-indicator {
        display: inline-block;
        width: 100px;
        height: 8px;
        background: #e0e0e0;
        border-radius: 4px;
        position: relative;
        overflow: hidden;
    }

    .balance-indicator .fill {
        position: absolute;
        left: 0;
        top: 0;
        height: 100%;
        background: linear-gradient(90deg, #11998e 0%, #38ef7d 100%);
        transition: width 0.3s;
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h3 class="mb-2">Leave Reports</h3>
                <p class="text-muted mb-0">Generate comprehensive leave reports and balance summaries</p>
            </div>
            <a href="<?= base_url('reports') ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Back to Reports
            </a>
        </div>
    </div>
</div>

<!-- Filters Section -->
<div class="filter-card">
    <h5><i class="fas fa-filter me-2"></i>Report Filters</h5>

    <form action="<?= base_url('reports/leave/generate') ?>" method="POST" id="reportForm">
        <?= csrf_field() ?>

        <!-- Report Type Selection -->
        <div class="report-type-selector">
            <label class="report-type-btn active" data-type="summary">
                <input type="radio" name="report_type" value="summary" checked hidden>
                <i class="fas fa-chart-pie"></i>
                <span>Summary</span>
            </label>
            <label class="report-type-btn" data-type="balance">
                <input type="radio" name="report_type" value="balance" hidden>
                <i class="fas fa-balance-scale"></i>
                <span>Balance</span>
            </label>
            <label class="report-type-btn" data-type="usage">
                <input type="radio" name="report_type" value="usage" hidden>
                <i class="fas fa-calendar-check"></i>
                <span>Usage</span>
            </label>
        </div>

        <div class="row g-3">
            <!-- Date Range -->
            <div class="col-md-3">
                <label class="form-label">From Date <span class="text-danger">*</span></label>
                <input type="date" class="form-control" name="date_from"
                       value="<?= $filters['date_from'] ?? date('Y-01-01') ?>" required>
            </div>

            <div class="col-md-3">
                <label class="form-label">To Date <span class="text-danger">*</span></label>
                <input type="date" class="form-control" name="date_to"
                       value="<?= $filters['date_to'] ?? date('Y-m-d') ?>" required>
            </div>

            <!-- Location Filter -->
            <div class="col-md-3">
                <label class="form-label">Location</label>
                <select class="form-select" name="location_id">
                    <option value="">All Locations</option>
                    <?php foreach ($locations as $location): ?>
                        <option value="<?= $location['id'] ?>"
                                <?= (isset($filters['location_id']) && $filters['location_id'] == $location['id']) ? 'selected' : '' ?>>
                            <?= esc($location['location_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- Department Filter -->
            <div class="col-md-3">
                <label class="form-label">Department</label>
                <select class="form-select" name="department_id">
                    <option value="">All Departments</option>
                    <?php foreach ($departments as $department): ?>
                        <option value="<?= $department['id'] ?>"
                                <?= (isset($filters['department_id']) && $filters['department_id'] == $department['id']) ? 'selected' : '' ?>>
                            <?= esc($department['department_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- Employee Filter -->
            <div class="col-md-6">
                <label class="form-label">Employee</label>
                <select class="form-select" name="employee_id">
                    <option value="">All Employees</option>
                    <?php foreach ($employees as $employee): ?>
                        <option value="<?= $employee['employee_id'] ?>"
                                <?= (isset($filters['employee_id']) && $filters['employee_id'] == $employee['employee_id']) ? 'selected' : '' ?>>
                            <?= esc($employee['employee_id'] . ' - ' . $employee['full_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- Status Filter -->
            <div class="col-md-3" id="statusFilter">
                <label class="form-label">Status</label>
                <select class="form-select" name="status">
                    <option value="">All Statuses</option>
                    <option value="approved" <?= (isset($filters['status']) && $filters['status'] == 'approved') ? 'selected' : '' ?>>Approved</option>
                    <option value="pending" <?= (isset($filters['status']) && $filters['status'] == 'pending') ? 'selected' : '' ?>>Pending</option>
                    <option value="rejected" <?= (isset($filters['status']) && $filters['status'] == 'rejected') ? 'selected' : '' ?>>Rejected</option>
                </select>
            </div>

            <!-- Export Format -->
            <div class="col-md-3">
                <label class="form-label">Export Format</label>
                <select class="form-select" name="export_format">
                    <option value="view">View in Browser</option>
                    <option value="pdf">PDF Document</option>
                    <option value="excel">Excel Spreadsheet</option>
                </select>
            </div>
        </div>

        <div class="mt-4">
            <button type="submit" class="btn btn-success btn-lg">
                <i class="fas fa-chart-line me-2"></i>Generate Report
            </button>
            <button type="reset" class="btn btn-outline-secondary btn-lg ms-2">
                <i class="fas fa-redo me-2"></i>Reset Filters
            </button>
        </div>
    </form>
</div>

<!-- Report Results -->
<?php if (isset($reportData) && !empty($reportData)): ?>
<div class="results-card">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5><i class="fas fa-table me-2"></i>Report Results</h5>
        <?php if (has_permission('export-reports')): ?>
        <div class="export-buttons">
            <a href="<?= base_url('reports/export/pdf') ?>" class="btn btn-sm btn-danger">
                <i class="fas fa-file-pdf me-1"></i>Export PDF
            </a>
            <a href="<?= base_url('reports/export/excel') ?>" class="btn btn-sm btn-success">
                <i class="fas fa-file-excel me-1"></i>Export Excel
            </a>
        </div>
        <?php endif; ?>
    </div>

    <div class="alert alert-info">
        <i class="fas fa-info-circle me-2"></i>
        Showing results from <strong><?= date('M d, Y', strtotime($filters['date_from'])) ?></strong>
        to <strong><?= date('M d, Y', strtotime($filters['date_to'])) ?></strong>
        (<?= count($reportData) ?> records)
    </div>

    <!-- Summary Report Table -->
    <?php if (isset($reportType) && $reportType == 'summary'): ?>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Employee ID</th>
                    <th>Employee Name</th>
                    <th>Department</th>
                    <th>Location</th>
                    <th>Leave Type</th>
                    <th class="text-center">Total Requests</th>
                    <th class="text-center">Total Days</th>
                    <th class="text-center">Approved</th>
                    <th class="text-center">Rejected</th>
                    <th class="text-center">Pending</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($reportData as $row): ?>
                <tr>
                    <td><?= esc($row['employee_id']) ?></td>
                    <td><?= esc($row['full_name']) ?></td>
                    <td><?= esc($row['department_name']) ?></td>
                    <td><?= esc($row['location_name']) ?></td>
                    <td>
                        <span class="badge bg-secondary"><?= esc($row['leave_type_name']) ?></span>
                    </td>
                    <td class="text-center"><strong><?= $row['total_requests'] ?></strong></td>
                    <td class="text-center"><strong><?= $row['total_days'] ?></strong></td>
                    <td class="text-center"><span class="badge bg-success"><?= $row['approved_count'] ?></span></td>
                    <td class="text-center"><span class="badge bg-danger"><?= $row['rejected_count'] ?></span></td>
                    <td class="text-center"><span class="badge bg-warning"><?= $row['pending_count'] ?></span></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>

    <!-- Balance Report Table -->
    <?php if (isset($reportType) && $reportType == 'balance'): ?>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Employee ID</th>
                    <th>Employee Name</th>
                    <th>Department</th>
                    <th>Location</th>
                    <th>Leave Type</th>
                    <th class="text-center">Allocated</th>
                    <th class="text-center">Used</th>
                    <th class="text-center">Remaining</th>
                    <th class="text-center">Year</th>
                    <th>Balance</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($reportData as $row): ?>
                <tr>
                    <td><?= esc($row['employee_id']) ?></td>
                    <td><?= esc($row['full_name']) ?></td>
                    <td><?= esc($row['department_name']) ?></td>
                    <td><?= esc($row['location_name']) ?></td>
                    <td>
                        <span class="badge bg-secondary"><?= esc($row['leave_type_name']) ?></span>
                    </td>
                    <td class="text-center"><strong><?= $row['allocated_days'] ?></strong></td>
                    <td class="text-center">
                        <span class="badge bg-info"><?= $row['used_days'] ?></span>
                    </td>
                    <td class="text-center">
                        <?php
                        $remaining = $row['remaining_days'];
                        $badgeClass = $remaining > 5 ? 'success' : ($remaining > 0 ? 'warning' : 'danger');
                        ?>
                        <span class="badge bg-<?= $badgeClass ?>"><?= $remaining ?></span>
                    </td>
                    <td class="text-center"><?= $row['year'] ?></td>
                    <td>
                        <?php
                        $percentage = $row['allocated_days'] > 0 ? ($row['remaining_days'] / $row['allocated_days']) * 100 : 0;
                        ?>
                        <div class="balance-indicator" title="<?= round($percentage, 1) ?>% remaining">
                            <div class="fill" style="width: <?= $percentage ?>%"></div>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>

    <!-- Usage Report Table -->
    <?php if (isset($reportType) && $reportType == 'usage'): ?>
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Employee ID</th>
                    <th>Employee Name</th>
                    <th>Department</th>
                    <th>Leave Type</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                    <th class="text-center">Days</th>
                    <th>Status</th>
                    <th>Reason</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($reportData as $row): ?>
                <tr>
                    <td><?= esc($row['employee_id']) ?></td>
                    <td><?= esc($row['full_name']) ?></td>
                    <td><?= esc($row['department_name']) ?></td>
                    <td>
                        <span class="badge bg-secondary"><?= esc($row['leave_type_name']) ?></span>
                    </td>
                    <td><?= date('M d, Y', strtotime($row['start_date'])) ?></td>
                    <td><?= date('M d, Y', strtotime($row['end_date'])) ?></td>
                    <td class="text-center"><strong><?= $row['total_days'] ?></strong></td>
                    <td>
                        <span class="status-badge status-<?= $row['status'] ?>">
                            <?= ucfirst($row['status']) ?>
                        </span>
                    </td>
                    <td>
                        <small><?= esc($row['reason']) ?></small>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>
</div>
<?php elseif (isset($reportData)): ?>
<div class="results-card">
    <div class="no-data">
        <i class="fas fa-inbox"></i>
        <h5>No Data Found</h5>
        <p>No leave records found for the selected filters. Try adjusting your search criteria.</p>
    </div>
</div>
<?php endif; ?>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Report type selector
    document.querySelectorAll('.report-type-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            document.querySelectorAll('.report-type-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');

            // Show/hide status filter based on report type
            const reportType = this.dataset.type;
            const statusFilter = document.getElementById('statusFilter');
            if (reportType === 'summary' || reportType === 'usage') {
                statusFilter.style.display = 'block';
            } else {
                statusFilter.style.display = 'none';
            }
        });
    });

    // Initialize status filter visibility
    const activeType = document.querySelector('.report-type-btn.active').dataset.type;
    const statusFilter = document.getElementById('statusFilter');
    if (activeType === 'balance') {
        statusFilter.style.display = 'none';
    }

    // Form validation
    document.getElementById('reportForm').addEventListener('submit', function(e) {
        const dateFrom = new Date(document.querySelector('[name="date_from"]').value);
        const dateTo = new Date(document.querySelector('[name="date_to"]').value);

        if (dateFrom > dateTo) {
            e.preventDefault();
            alert('From Date must be before or equal to To Date');
            return false;
        }
    });
</script>
<?= $this->endSection() ?>
