<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<style>
    .report-card {
        background: white;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
        border-left: 4px solid transparent;
        height: 100%;
    }

    .report-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12);
    }

    .report-card.attendance {
        border-left-color: #667eea;
    }

    .report-card.leave {
        border-left-color: #11998e;
    }

    .report-card.scheduled {
        border-left-color: #f093fb;
    }

    .report-card.custom {
        border-left-color: #ffa502;
    }

    .report-icon {
        width: 60px;
        height: 60px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 28px;
        color: white;
        margin-bottom: 20px;
    }

    .report-card.attendance .report-icon {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .report-card.leave .report-icon {
        background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    }

    .report-card.scheduled .report-icon {
        background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }

    .report-card.custom .report-icon {
        background: linear-gradient(135deg, #ffa502 0%, #ff6348 100%);
    }

    .report-card h4 {
        font-weight: 600;
        margin-bottom: 10px;
        color: #333;
    }

    .report-card p {
        color: #666;
        margin-bottom: 20px;
        line-height: 1.6;
    }

    .report-card .btn {
        width: 100%;
    }

    .quick-stats {
        background: white;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        margin-bottom: 30px;
    }

    .quick-stats h5 {
        font-weight: 600;
        margin-bottom: 20px;
    }

    .stat-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 12px 0;
        border-bottom: 1px solid #f0f0f0;
    }

    .stat-item:last-child {
        border-bottom: none;
    }

    .stat-label {
        color: #666;
        font-size: 14px;
    }

    .stat-value {
        font-weight: 600;
        font-size: 16px;
        color: #333;
    }

    .recent-reports {
        background: white;
        border-radius: 12px;
        padding: 25px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .recent-reports h5 {
        font-weight: 600;
        margin-bottom: 20px;
    }

    .report-item {
        display: flex;
        align-items: center;
        padding: 15px;
        border-radius: 8px;
        background: #f8f9fa;
        margin-bottom: 10px;
        transition: background 0.2s;
    }

    .report-item:hover {
        background: #e9ecef;
    }

    .report-item i {
        font-size: 24px;
        margin-right: 15px;
        color: #667eea;
    }

    .report-info {
        flex-grow: 1;
    }

    .report-name {
        font-weight: 600;
        color: #333;
        margin-bottom: 3px;
    }

    .report-date {
        font-size: 12px;
        color: #999;
    }
</style>

<!-- Page Header -->
<div class="row mb-4">
    <div class="col-md-12">
        <h3 class="mb-2">Reports Dashboard</h3>
        <p class="text-muted">Generate and manage various reports for attendance, leave, and employee data</p>
    </div>
</div>

<!-- Quick Statistics -->
<div class="quick-stats">
    <h5><i class="fas fa-chart-line me-2"></i>Quick Statistics</h5>
    <div class="row">
        <div class="col-md-3">
            <div class="stat-item">
                <span class="stat-label">Today's Attendance</span>
                <span class="stat-value <?= $statistics['attendance_rate'] >= 80 ? 'text-success' : ($statistics['attendance_rate'] >= 60 ? 'text-warning' : 'text-danger') ?>">
                    <?= esc($statistics['attendance_rate']) ?>%
                </span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-item">
                <span class="stat-label">Pending Leaves</span>
                <span class="stat-value <?= $statistics['pending_leaves'] > 10 ? 'text-warning' : 'text-muted' ?>">
                    <?= esc($statistics['pending_leaves']) ?>
                </span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-item">
                <span class="stat-label">Reports This Month</span>
                <span class="stat-value"><?= esc($statistics['reports_this_month']) ?></span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-item">
                <span class="stat-label">Scheduled Reports</span>
                <span class="stat-value"><?= esc($statistics['scheduled_reports']) ?></span>
            </div>
        </div>
    </div>
</div>

<!-- Report Types -->
<div class="row g-4 mb-4">
    <!-- Attendance Reports -->
    <div class="col-md-6 col-lg-3">
        <div class="report-card attendance">
            <div class="report-icon">
                <i class="fas fa-clock"></i>
            </div>
            <h4>Attendance Reports</h4>
            <p>Generate comprehensive attendance reports including summary, detailed, and daily attendance data.</p>
            <a href="<?= base_url('reports/attendance') ?>" class="btn btn-primary">
                <i class="fas fa-arrow-right me-2"></i>Generate Report
            </a>
        </div>
    </div>

    <!-- Leave Reports -->
    <div class="col-md-6 col-lg-3">
        <div class="report-card leave">
            <div class="report-icon">
                <i class="fas fa-calendar-alt"></i>
            </div>
            <h4>Leave Reports</h4>
            <p>View leave summaries, balances, and usage reports for employees across all departments.</p>
            <a href="<?= base_url('reports/leave') ?>" class="btn btn-success">
                <i class="fas fa-arrow-right me-2"></i>Generate Report
            </a>
        </div>
    </div>

    <!-- Scheduled Reports -->
    <?php if (has_permission('schedule-reports')): ?>
    <div class="col-md-6 col-lg-3">
        <div class="report-card scheduled">
            <div class="report-icon">
                <i class="fas fa-calendar-check"></i>
            </div>
            <h4>Scheduled Reports</h4>
            <p>Manage automated reports that are generated and sent on a recurring schedule.</p>
            <a href="<?= base_url('reports/scheduled') ?>" class="btn btn-info">
                <i class="fas fa-arrow-right me-2"></i>Manage Schedule
            </a>
        </div>
    </div>
    <?php endif; ?>

    <!-- Custom Reports (Future Feature) -->
    <div class="col-md-6 col-lg-3">
        <div class="report-card custom">
            <div class="report-icon">
                <i class="fas fa-chart-bar"></i>
            </div>
            <h4>Custom Reports</h4>
            <p>Create custom reports with specific filters and data points tailored to your needs.</p>
            <button class="btn btn-warning" disabled>
                <i class="fas fa-lock me-2"></i>Coming Soon
            </button>
        </div>
    </div>
</div>

<!-- Recent Reports & Export Options -->
<div class="row g-4">
    <!-- Recent Reports -->
    <div class="col-md-8">
        <div class="recent-reports">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5><i class="fas fa-history me-2"></i>Recent Reports</h5>
                <button class="btn btn-sm btn-outline-primary" onclick="refreshRecentReports()">
                    <i class="fas fa-sync-alt me-2"></i>Refresh
                </button>
            </div>

            <?php if (!empty($recentReports)): ?>
                <?php foreach ($recentReports as $report): ?>
                    <?php
                        $reportType = json_decode($report['new_data'], true);
                        $reportName = $reportType['report_type'] ?? 'Report';
                        $reportFormat = $reportType['format'] ?? 'PDF';
                        $iconClass = $reportFormat === 'excel' ? 'fas fa-file-excel text-success' :
                                    ($reportFormat === 'csv' ? 'fas fa-file-csv text-info' : 'fas fa-file-pdf text-danger');
                    ?>
                    <div class="report-item">
                        <i class="<?= $iconClass ?>"></i>
                        <div class="report-info">
                            <div class="report-name"><?= esc(ucwords(str_replace('_', ' ', $reportName))) ?></div>
                            <div class="report-date">
                                Generated by <?= esc($report['first_name'] . ' ' . $report['last_name']) ?>
                                on <?= date('M d, Y \a\t g:i A', strtotime($report['created_at'])) ?>
                            </div>
                        </div>
                        <button class="btn btn-sm btn-outline-secondary" title="Re-generate report">
                            <i class="fas fa-redo"></i>
                        </button>
                    </div>
                <?php endforeach; ?>

                <div class="text-center mt-3">
                    <p class="text-muted mb-0">Showing <?= count($recentReports) ?> most recent reports</p>
                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-file-alt fa-3x text-muted mb-3"></i>
                    <p class="text-muted">No reports have been generated yet</p>
                    <a href="<?= base_url('reports/attendance') ?>" class="btn btn-sm btn-primary">
                        <i class="fas fa-plus me-2"></i>Generate Your First Report
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Export Options -->
    <div class="col-md-4">
        <div class="table-card">
            <h5><i class="fas fa-download me-2"></i>Export Options</h5>
            <p class="text-muted small mb-3">Available export formats for reports</p>

            <div class="list-group">
                <div class="list-group-item">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-file-pdf text-danger fs-4 me-3"></i>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">PDF Format</h6>
                            <small class="text-muted">Professional printable reports</small>
                        </div>
                        <i class="fas fa-check-circle text-success"></i>
                    </div>
                </div>

                <div class="list-group-item">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-file-excel text-success fs-4 me-3"></i>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">Excel Format</h6>
                            <small class="text-muted">Editable spreadsheet format</small>
                        </div>
                        <i class="fas fa-check-circle text-success"></i>
                    </div>
                </div>

                <div class="list-group-item">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-file-csv text-primary fs-4 me-3"></i>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">CSV Format</h6>
                            <small class="text-muted">Universal data format</small>
                        </div>
                        <span class="badge bg-warning">Coming Soon</span>
                    </div>
                </div>
            </div>

            <div class="mt-4">
                <h6>Report Features</h6>
                <ul class="list-unstyled small">
                    <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Custom date ranges</li>
                    <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Department filtering</li>
                    <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Location filtering</li>
                    <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Employee-specific reports</li>
                    <li class="mb-2"><i class="fas fa-check text-success me-2"></i>Automated scheduling</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Refresh recent reports
    function refreshRecentReports() {
        const recentReportsDiv = document.querySelector('.recent-reports');
        const originalHTML = recentReportsDiv.innerHTML;

        // Show loading state
        recentReportsDiv.innerHTML = '<div class="text-center py-5"><i class="fas fa-spinner fa-spin fa-2x text-primary"></i><p class="mt-3">Loading recent reports...</p></div>';

        // Reload the page to get fresh data
        setTimeout(() => {
            window.location.reload();
        }, 500);
    }

    // Auto-refresh statistics every 5 minutes
    setInterval(() => {
        console.log('Auto-refreshing dashboard statistics...');
        // Could implement AJAX refresh here instead of full page reload
    }, 300000); // 5 minutes

    console.log('Reports Dashboard loaded');
</script>
<?= $this->endSection() ?>
