<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-file-alt me-2"></i><?= esc($pageTitle) ?></h2>
    <div>
        <a href="<?= base_url('leave/requests') ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left"></i> Back to Requests
        </a>
    </div>
</div>

<div class="row">
    <!-- Employee Information -->
    <div class="col-md-4 mb-4">
        <div class="table-card text-center">
            <?php if (!empty($request['photo'])): ?>
            <img src="<?= base_url('uploads/employees/' . $request['photo']) ?>"
                 alt="<?= esc($request['first_name']) ?>"
                 class="rounded-circle mb-3"
                 style="width: 120px; height: 120px; object-fit: cover;">
            <?php else: ?>
            <div class="rounded-circle bg-secondary text-white d-inline-flex align-items-center justify-content-center mb-3"
                 style="width: 120px; height: 120px; font-size: 48px;">
                <i class="fas fa-user"></i>
            </div>
            <?php endif; ?>

            <h4><?= esc($request['first_name'] . ' ' . $request['last_name']) ?></h4>
            <p class="text-muted mb-1"><?= esc($request['employee_number']) ?></p>
            <p class="text-muted mb-3"><?= esc($request['department_name'] ?? 'N/A') ?></p>

            <!-- Status Badge -->
            <div class="mb-3">
                <?php
                $statusColors = [
                    'Pending' => 'warning',
                    'Approved' => 'success',
                    'Rejected' => 'danger',
                ];
                $statusColor = $statusColors[$request['status']] ?? 'secondary';
                ?>
                <span class="badge bg-<?= $statusColor ?> fs-6">
                    <i class="fas fa-<?= $request['status'] == 'Approved' ? 'check' : ($request['status'] == 'Rejected' ? 'times' : 'clock') ?>"></i>
                    <?= esc($request['status']) ?>
                </span>
            </div>
        </div>

        <!-- Quick Info Card -->
        <div class="table-card mt-3">
            <h5 class="mb-3"><i class="fas fa-info-circle me-2"></i>Quick Info</h5>
            <div class="d-flex justify-content-between mb-2">
                <span>Department</span>
                <strong><?= esc($request['department_name'] ?? 'N/A') ?></strong>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span>Location</span>
                <strong><?= esc($request['location_name'] ?? 'N/A') ?></strong>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span>Email</span>
                <strong><small><?= esc($request['email']) ?></small></strong>
            </div>
            <div class="d-flex justify-content-between">
                <span>Phone</span>
                <strong><?= esc($request['phone'] ?? 'N/A') ?></strong>
            </div>
        </div>
    </div>

    <!-- Leave Request Details -->
    <div class="col-md-8">
        <!-- Leave Information -->
        <div class="table-card mb-4">
            <h5 class="mb-3"><i class="fas fa-calendar-alt me-2"></i>Leave Information</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="p-3 bg-light rounded">
                        <div class="d-flex align-items-center">
                            <div class="me-3" style="width: 50px; height: 50px; border-radius: 50%; background-color: <?= esc($request['color']) ?>; display: flex; align-items: center; justify-content: center; color: white;">
                                <i class="fas fa-briefcase fa-lg"></i>
                            </div>
                            <div>
                                <small class="text-muted">Leave Type</small>
                                <h5 class="mb-0"><?= esc($request['leave_type_name']) ?></h5>
                                <small class="badge bg-<?= $request['is_paid'] ? 'success' : 'secondary' ?>">
                                    <?= $request['is_paid'] ? 'Paid Leave' : 'Unpaid Leave' ?>
                                </small>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <div class="p-3 bg-light rounded">
                        <div class="d-flex align-items-center">
                            <div class="me-3" style="width: 50px; height: 50px; border-radius: 50%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white;">
                                <i class="fas fa-calendar-check fa-lg"></i>
                            </div>
                            <div>
                                <small class="text-muted">Total Days</small>
                                <h5 class="mb-0"><?= number_format($request['total_days'], 1) ?> day(s)</h5>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Start Date</label>
                    <h5><?= date('M d, Y', strtotime($request['start_date'])) ?></h5>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="text-muted small">End Date</label>
                    <h5><?= date('M d, Y', strtotime($request['end_date'])) ?></h5>
                </div>

                <div class="col-md-12 mb-3">
                    <label class="text-muted small">Reason</label>
                    <div class="p-3 bg-light rounded">
                        <?= nl2br(esc($request['reason'])) ?>
                    </div>
                </div>

                <?php if (!empty($request['attachment'])): ?>
                <div class="col-md-12 mb-3">
                    <label class="text-muted small">Supporting Document</label>
                    <div class="p-3 bg-light rounded">
                        <i class="fas fa-file-alt me-2"></i>
                        <a href="<?= base_url('uploads/leave-documents/' . $request['attachment']) ?>" target="_blank">
                            <?= esc($request['attachment']) ?>
                        </a>
                        <a href="<?= base_url('uploads/leave-documents/' . $request['attachment']) ?>" download class="btn btn-sm btn-outline-primary ms-2">
                            <i class="fas fa-download"></i> Download
                        </a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Approval Information -->
        <?php if ($request['status'] != 'Pending'): ?>
        <div class="table-card mb-4">
            <h5 class="mb-3">
                <i class="fas fa-<?= $request['status'] == 'Approved' ? 'check-circle' : 'times-circle' ?> me-2"></i>
                <?= $request['status'] ?> Information
            </h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="text-muted small"><?= $request['status'] ?> By</label>
                    <h5><?= esc($request['approved_by_name'] ?? 'System') ?></h5>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="text-muted small"><?= $request['status'] ?> At</label>
                    <h5><?= date('M d, Y h:i A', strtotime($request['approved_at'])) ?></h5>
                </div>

                <?php if ($request['status'] == 'Approved' && !empty($request['approval_comments'])): ?>
                <div class="col-md-12">
                    <label class="text-muted small">Comments</label>
                    <div class="p-3 bg-light rounded">
                        <?= nl2br(esc($request['approval_comments'])) ?>
                    </div>
                </div>
                <?php endif; ?>

                <?php if ($request['status'] == 'Rejected' && !empty($request['rejection_reason'])): ?>
                <div class="col-md-12">
                    <label class="text-muted small">Rejection Reason</label>
                    <div class="alert alert-danger mb-0">
                        <?= nl2br(esc($request['rejection_reason'])) ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Actions (for pending requests) -->
        <?php
        // Check if current user can approve this leave request
        $canApprove = has_permission('approve-leave') && $request['status'] == 'Pending';
        if ($canApprove && !is_super_admin()) {
            // Must be a manager in the same department
            $canApprove = $isManager && ($currentUserDepartmentId == $request['department_id']);
        }
        ?>
        <?php if ($canApprove): ?>
        <div class="table-card mb-4">
            <h5 class="mb-3"><i class="fas fa-tasks me-2"></i>Actions</h5>
            <div class="d-flex gap-2">
                <button class="btn btn-success" id="approveBtn">
                    <i class="fas fa-check"></i> Approve Request
                </button>
                <button class="btn btn-danger" id="rejectBtn">
                    <i class="fas fa-times"></i> Reject Request
                </button>
            </div>
        </div>
        <?php endif; ?>

        <!-- System Information -->
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-cog me-2"></i>System Information</h5>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Request Submitted</label>
                    <p class="mb-0"><?= date('M d, Y h:i A', strtotime($request['created_at'])) ?></p>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="text-muted small">Last Updated</label>
                    <p class="mb-0"><?= date('M d, Y h:i A', strtotime($request['updated_at'])) ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Approval Modal -->
<div class="modal fade" id="approveModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title"><i class="fas fa-check-circle me-2"></i>Approve Leave Request</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to approve the leave request for <strong><?= esc($request['first_name'] . ' ' . $request['last_name']) ?></strong>?</p>
                <div class="mb-3">
                    <label class="form-label">Comments (Optional)</label>
                    <textarea class="form-control" id="approveComments" rows="3" placeholder="Add any comments..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" id="confirmApprove">Approve</button>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white">
                <h5 class="modal-title"><i class="fas fa-times-circle me-2"></i>Reject Leave Request</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to reject the leave request for <strong><?= esc($request['first_name'] . ' ' . $request['last_name']) ?></strong>?</p>
                <div class="mb-3">
                    <label class="form-label">Rejection Reason <span class="text-danger">*</span></label>
                    <textarea class="form-control" id="rejectionReason" rows="3" placeholder="Enter reason for rejection..." required></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmReject">Reject</button>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
<?php if ($canApprove): ?>
const approveModal = new bootstrap.Modal(document.getElementById('approveModal'));
const rejectModal = new bootstrap.Modal(document.getElementById('rejectModal'));

// Approve button click
document.getElementById('approveBtn').addEventListener('click', function() {
    document.getElementById('approveComments').value = '';
    approveModal.show();
});

// Reject button click
document.getElementById('rejectBtn').addEventListener('click', function() {
    document.getElementById('rejectionReason').value = '';
    rejectModal.show();
});

// Confirm approve
document.getElementById('confirmApprove').addEventListener('click', function() {
    const comments = document.getElementById('approveComments').value;

    fetch('<?= base_url('leave/requests/approve/' . $request['id']) ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({ comments: comments })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.reload();
        } else {
            alert(data.message || 'Failed to approve request');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred');
    });
});

// Confirm reject
document.getElementById('confirmReject').addEventListener('click', function() {
    const reason = document.getElementById('rejectionReason').value;

    if (!reason) {
        alert('Please enter a rejection reason');
        return;
    }

    fetch('<?= base_url('leave/requests/reject/' . $request['id']) ?>', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify({ rejection_reason: reason })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            window.location.reload();
        } else {
            alert(data.message || 'Failed to reject request');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('An error occurred');
    });
});
<?php endif; ?>
</script>
<?= $this->endSection() ?>
