<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus-circle me-2"></i><?= esc($pageTitle) ?></h2>
    <a href="<?= base_url('leave/requests') ?>" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Back to Requests
    </a>
</div>

<!-- Flash Messages -->
<?php if (session()->has('errors')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <strong>Please fix the following errors:</strong>
    <ul class="mb-0 mt-2">
        <?php foreach (session('errors') as $error): ?>
        <li><?= esc($error) ?></li>
        <?php endforeach; ?>
    </ul>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (session()->has('error')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i><?= session('error') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Leave Request Form -->
<form action="<?= base_url('leave/requests/store') ?>" method="post" enctype="multipart/form-data" id="leaveRequestForm">
    <?= csrf_field() ?>

    <div class="row">
        <!-- Form Fields -->
        <div class="col-md-8">
            <!-- Leave Information -->
            <div class="table-card mb-4">
                <h5 class="mb-3"><i class="fas fa-info-circle me-2"></i>Leave Information</h5>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="employee_id" class="form-label">Employee <span class="text-danger">*</span></label>
                        <select class="form-select" id="employee_id" name="employee_id" required>
                            <option value="">Select Employee</option>
                            <?php foreach ($employees as $employee): ?>
                            <option value="<?= $employee['employee_id'] ?>" <?= old('employee_id') == $employee['employee_id'] ? 'selected' : '' ?>>
                                <?= esc($employee['employee_number'] . ' - ' . $employee['first_name'] . ' ' . $employee['last_name']) ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="leave_type_id" class="form-label">Leave Type <span class="text-danger">*</span></label>
                        <select class="form-select" id="leave_type_id" name="leave_type_id" required>
                            <option value="">Select Leave Type</option>
                            <?php foreach ($leaveTypes as $type): ?>
                            <option value="<?= $type['id'] ?>"
                                    data-color="<?= esc($type['color']) ?>"
                                    data-days="<?= $type['days_per_year'] ?>"
                                    data-paid="<?= $type['is_paid'] ?>"
                                    data-requires-doc="<?= $type['requires_document'] ?>"
                                    <?= old('leave_type_id') == $type['id'] ? 'selected' : '' ?>>
                                <?= esc($type['name']) ?> (<?= $type['days_per_year'] ?> days/year)
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="start_date" class="form-label">Start Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="start_date" name="start_date"
                               value="<?= old('start_date') ?>" required min="<?= date('Y-m-d') ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="end_date" class="form-label">End Date <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="end_date" name="end_date"
                               value="<?= old('end_date') ?>" required min="<?= date('Y-m-d') ?>">
                    </div>

                    <div class="col-md-12 mb-3">
                        <label for="reason" class="form-label">Reason <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="reason" name="reason" rows="4" required
                                  placeholder="Please provide a detailed reason for your leave request (minimum 10 characters)"><?= old('reason') ?></textarea>
                        <small class="text-muted">Minimum 10 characters</small>
                    </div>

                    <div class="col-md-12 mb-3" id="attachmentField" style="display: none;">
                        <label for="attachment" class="form-label">Supporting Document</label>
                        <input type="file" class="form-control" id="attachment" name="attachment"
                               accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                        <small class="text-muted">Accepted: PDF, DOC, DOCX, JPG, PNG (Max 5MB)</small>
                    </div>
                </div>
            </div>

            <!-- Duration Summary -->
            <div class="table-card mb-4" id="durationSummary" style="display: none;">
                <h5 class="mb-3"><i class="fas fa-calendar-check me-2"></i>Duration Summary</h5>
                <div class="row text-center">
                    <div class="col-md-4">
                        <div class="p-3 bg-light rounded">
                            <small class="text-muted">Start Date</small>
                            <h5 id="summaryStartDate" class="mb-0">-</h5>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="p-3 bg-light rounded">
                            <small class="text-muted">End Date</small>
                            <h5 id="summaryEndDate" class="mb-0">-</h5>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="p-3 bg-primary text-white rounded">
                            <small>Total Days</small>
                            <h5 id="totalDays" class="mb-0">0</h5>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="d-flex justify-content-end gap-2">
                <a href="<?= base_url('leave/requests') ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Cancel
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-paper-plane"></i> Submit Request
                </button>
            </div>
        </div>

        <!-- Help & Info Panel -->
        <div class="col-md-4">
            <!-- Leave Type Info -->
            <div class="table-card mb-3" id="leaveTypeInfo" style="display: none;">
                <h5 class="mb-3"><i class="fas fa-info-circle me-2"></i>Leave Type Details</h5>
                <div id="leaveTypeDetails">
                    <div class="mb-2">
                        <small class="text-muted">Allocation per Year</small>
                        <p class="mb-0"><strong id="typeAllocation">-</strong> days</p>
                    </div>
                    <div class="mb-2">
                        <small class="text-muted">Leave Type</small>
                        <p class="mb-0"><span id="typePaidStatus" class="badge bg-success">Paid</span></p>
                    </div>
                    <div class="mb-2">
                        <small class="text-muted">Document Required</small>
                        <p class="mb-0"><span id="typeDocRequired" class="badge bg-info">Yes</span></p>
                    </div>
                </div>
            </div>

            <!-- Guidelines -->
            <div class="table-card">
                <h5 class="mb-3"><i class="fas fa-lightbulb me-2"></i>Guidelines</h5>
                <ul class="small mb-0">
                    <li class="mb-2">Submit leave requests at least 3 days in advance for planned leaves</li>
                    <li class="mb-2">Provide detailed reasons for your leave request</li>
                    <li class="mb-2">Attach supporting documents if required (medical certificates, etc.)</li>
                    <li class="mb-2">Check your leave balance before submitting</li>
                    <li class="mb-2">Emergency leaves can be submitted on the same day with proper justification</li>
                    <li class="mb-2">You will receive a notification once your request is reviewed</li>
                </ul>
            </div>
        </div>
    </div>
</form>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
// Calculate days between dates
function calculateDays() {
    const startDate = document.getElementById('start_date').value;
    const endDate = document.getElementById('end_date').value;

    if (startDate && endDate) {
        const start = new Date(startDate);
        const end = new Date(endDate);
        const diffTime = end - start;
        const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24)) + 1; // Include both start and end dates

        if (diffDays > 0) {
            document.getElementById('totalDays').textContent = diffDays;
            document.getElementById('summaryStartDate').textContent = start.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
            document.getElementById('summaryEndDate').textContent = end.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
            document.getElementById('durationSummary').style.display = 'block';
        } else {
            document.getElementById('durationSummary').style.display = 'none';
            alert('End date must be after start date');
        }
    }
}

// Update leave type info
document.getElementById('leave_type_id').addEventListener('change', function() {
    const selectedOption = this.options[this.selectedIndex];

    if (selectedOption.value) {
        const days = selectedOption.dataset.days;
        const isPaid = selectedOption.dataset.paid == '1';
        const requiresDoc = selectedOption.dataset.requiresDoc == '1';

        document.getElementById('typeAllocation').textContent = days;
        document.getElementById('typePaidStatus').textContent = isPaid ? 'Paid Leave' : 'Unpaid Leave';
        document.getElementById('typePaidStatus').className = isPaid ? 'badge bg-success' : 'badge bg-secondary';
        document.getElementById('typeDocRequired').textContent = requiresDoc ? 'Required' : 'Not Required';
        document.getElementById('typeDocRequired').className = requiresDoc ? 'badge bg-warning' : 'badge bg-info';

        // Show/hide attachment field
        document.getElementById('attachmentField').style.display = requiresDoc ? 'block' : 'none';
        if (requiresDoc) {
            document.getElementById('attachment').required = true;
        } else {
            document.getElementById('attachment').required = false;
        }

        document.getElementById('leaveTypeInfo').style.display = 'block';
    } else {
        document.getElementById('leaveTypeInfo').style.display = 'none';
        document.getElementById('attachmentField').style.display = 'none';
    }
});

// Date change listeners
document.getElementById('start_date').addEventListener('change', calculateDays);
document.getElementById('end_date').addEventListener('change', function() {
    // Update minimum end date
    const startDate = document.getElementById('start_date').value;
    if (startDate) {
        this.min = startDate;
    }
    calculateDays();
});

// Form validation
document.getElementById('leaveRequestForm').addEventListener('submit', function(e) {
    const startDate = new Date(document.getElementById('start_date').value);
    const endDate = new Date(document.getElementById('end_date').value);
    const reason = document.getElementById('reason').value;

    if (endDate < startDate) {
        e.preventDefault();
        alert('End date must be after or equal to start date');
        return false;
    }

    if (reason.length < 10) {
        e.preventDefault();
        alert('Please provide a more detailed reason (minimum 10 characters)');
        return false;
    }

    // Check file size if attachment is provided
    const attachment = document.getElementById('attachment').files[0];
    if (attachment && attachment.size > 5 * 1024 * 1024) {
        e.preventDefault();
        alert('File size must not exceed 5MB');
        return false;
    }
});
</script>
<?= $this->endSection() ?>
