<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-chart-pie me-2"></i><?= esc($pageTitle) ?></h2>
    <a href="<?= base_url('leave/requests') ?>" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Back to Requests
    </a>
</div>

<!-- Filters -->
<div class="table-card mb-4">
    <form method="get" action="<?= base_url('leave/balances') ?>" class="row g-3">
        <div class="col-md-4">
            <label class="form-label"><i class="fas fa-user me-1"></i>Select Employee <span class="text-danger">*</span></label>
            <select name="employee_id" class="form-select" required onchange="this.form.submit()">
                <option value="">-- Select Employee --</option>
                <?php foreach ($employees as $employee): ?>
                <option value="<?= $employee['employee_id'] ?>" <?= ($selectedEmployeeId == $employee['employee_id']) ? 'selected' : '' ?>>
                    <?= esc($employee['employee_number'] . ' - ' . $employee['first_name'] . ' ' . $employee['last_name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-3">
            <label class="form-label"><i class="fas fa-calendar me-1"></i>Year</label>
            <select name="year" class="form-select" onchange="this.form.submit()">
                <?php for ($y = date('Y') - 2; $y <= date('Y') + 1; $y++): ?>
                <option value="<?= $y ?>" <?= ($selectedYear == $y) ? 'selected' : '' ?>><?= $y ?></option>
                <?php endfor; ?>
            </select>
        </div>

        <div class="col-md-3 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">
                <i class="fas fa-search"></i> View Balances
            </button>
        </div>
    </form>
</div>

<?php if ($selectedEmployeeId && !empty($balances)): ?>
<!-- Employee Info Summary -->
<?php
$employee = null;
foreach ($employees as $emp) {
    if ($emp['id'] == $selectedEmployeeId) {
        $employee = $emp;
        break;
    }
}
?>

<?php if ($employee): ?>
<div class="table-card mb-4">
    <div class="row align-items-center">
        <div class="col-md-8">
            <div class="d-flex align-items-center">
                <?php if (!empty($employee['photo'])): ?>
                <img src="<?= base_url('uploads/employees/' . $employee['photo']) ?>"
                     alt="<?= esc($employee['first_name']) ?>"
                     class="rounded-circle me-3"
                     style="width: 60px; height: 60px; object-fit: cover;">
                <?php else: ?>
                <div class="rounded-circle bg-secondary text-white d-flex align-items-center justify-content-center me-3"
                     style="width: 60px; height: 60px;">
                    <i class="fas fa-user fa-lg"></i>
                </div>
                <?php endif; ?>
                <div>
                    <h4 class="mb-0"><?= esc($employee['first_name'] . ' ' . $employee['last_name']) ?></h4>
                    <p class="text-muted mb-0">
                        <?= esc($employee['employee_number']) ?> |
                        <?= esc($employee['department_name'] ?? 'N/A') ?>
                    </p>
                </div>
            </div>
        </div>
        <div class="col-md-4 text-end">
            <h5 class="text-muted mb-0">Leave Year</h5>
            <h3 class="mb-0"><?= $selectedYear ?></h3>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Leave Balances Table -->
<div class="table-card">
    <h5 class="mb-3"><i class="fas fa-list-alt me-2"></i>Leave Balances</h5>
    <div class="table-responsive">
        <table class="table table-hover align-middle">
            <thead>
                <tr>
                    <th>Leave Type</th>
                    <th class="text-center">Allocated</th>
                    <th class="text-center">Used</th>
                    <th class="text-center">Pending</th>
                    <th class="text-center">Available</th>
                    <th class="text-center">Balance %</th>
                    <th class="text-center">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $totalAllocated = 0;
                $totalUsed = 0;
                $totalPending = 0;
                $totalAvailable = 0;
                ?>
                <?php foreach ($balances as $balance): ?>
                <?php
                $allocated = $balance['allocated_days'] ?? 0;
                $used = $balance['used_days'] ?? 0;
                $pending = $balance['pending_days'] ?? 0;
                $available = $allocated - $used - $pending;
                $percentage = $allocated > 0 ? (($used + $pending) / $allocated) * 100 : 0;

                $totalAllocated += $allocated;
                $totalUsed += $used;
                $totalPending += $pending;
                $totalAvailable += $available;
                ?>
                <tr>
                    <td>
                        <div class="d-flex align-items-center">
                            <div class="me-2" style="width: 20px; height: 20px; border-radius: 4px; background-color: <?= esc($balance['color']) ?>"></div>
                            <strong><?= esc($balance['leave_type_name']) ?></strong>
                        </div>
                    </td>
                    <td class="text-center">
                        <strong><?= number_format($allocated, 1) ?></strong>
                    </td>
                    <td class="text-center">
                        <span class="badge bg-danger"><?= number_format($used, 1) ?></span>
                    </td>
                    <td class="text-center">
                        <span class="badge bg-warning"><?= number_format($pending, 1) ?></span>
                    </td>
                    <td class="text-center">
                        <span class="badge bg-success"><?= number_format($available, 1) ?></span>
                    </td>
                    <td class="text-center">
                        <div class="progress" style="height: 20px;">
                            <div class="progress-bar <?= $percentage >= 80 ? 'bg-danger' : ($percentage >= 50 ? 'bg-warning' : 'bg-success') ?>"
                                 role="progressbar"
                                 style="width: <?= min($percentage, 100) ?>%"
                                 aria-valuenow="<?= $percentage ?>"
                                 aria-valuemin="0"
                                 aria-valuemax="100">
                                <?= round($percentage) ?>%
                            </div>
                        </div>
                    </td>
                    <td class="text-center">
                        <?php if ($available <= 0): ?>
                        <span class="badge bg-danger">Exhausted</span>
                        <?php elseif ($percentage >= 80): ?>
                        <span class="badge bg-warning">Low</span>
                        <?php else: ?>
                        <span class="badge bg-success">Available</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot class="table-light">
                <tr>
                    <th>TOTAL</th>
                    <th class="text-center"><?= number_format($totalAllocated, 1) ?></th>
                    <th class="text-center"><span class="badge bg-danger"><?= number_format($totalUsed, 1) ?></span></th>
                    <th class="text-center"><span class="badge bg-warning"><?= number_format($totalPending, 1) ?></span></th>
                    <th class="text-center"><span class="badge bg-success"><?= number_format($totalAvailable, 1) ?></span></th>
                    <th colspan="2"></th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row g-3 mt-4">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <i class="fas fa-calendar-check"></i>
            </div>
            <h6>Total Allocated</h6>
            <div class="value"><?= number_format($totalAllocated, 1) ?></div>
            <div class="change text-muted">days for <?= $selectedYear ?></div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #ee0979 0%, #ff6a00 100%);">
                <i class="fas fa-minus-circle"></i>
            </div>
            <h6>Total Used</h6>
            <div class="value"><?= number_format($totalUsed, 1) ?></div>
            <div class="change text-muted">
                <?= $totalAllocated > 0 ? round(($totalUsed / $totalAllocated) * 100) : 0 ?>% of total
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <i class="fas fa-clock"></i>
            </div>
            <h6>Pending Approval</h6>
            <div class="value"><?= number_format($totalPending, 1) ?></div>
            <div class="change text-muted">awaiting decision</div>
        </div>
    </div>

    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
                <i class="fas fa-check-circle"></i>
            </div>
            <h6>Available Balance</h6>
            <div class="value"><?= number_format($totalAvailable, 1) ?></div>
            <div class="change text-<?= $totalAvailable > 5 ? 'success' : 'danger' ?>">
                <?= $totalAvailable > 5 ? 'Good balance' : 'Low balance' ?>
            </div>
        </div>
    </div>
</div>

<?php elseif ($selectedEmployeeId && empty($balances)): ?>
<!-- No Balances Found -->
<div class="table-card text-center py-5">
    <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
    <h5 class="text-muted">No Leave Balances Found</h5>
    <p class="text-muted">No leave balances have been allocated for the selected employee and year.</p>
</div>

<?php else: ?>
<!-- No Employee Selected -->
<div class="table-card text-center py-5">
    <i class="fas fa-user-clock fa-4x text-muted mb-3"></i>
    <h5 class="text-muted">Select an Employee</h5>
    <p class="text-muted">Please select an employee from the filter above to view their leave balances.</p>
</div>
<?php endif; ?>

<?= $this->endSection() ?>
