<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-user-plus me-2"></i><?= esc($pageTitle) ?></h2>
    <a href="<?= base_url('employees') ?>" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Back to List
    </a>
</div>

<!-- Flash Messages -->
<?php if (session()->has('errors')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <strong>Please fix the following errors:</strong>
    <ul class="mb-0 mt-2">
        <?php foreach (session('errors') as $error): ?>
        <li><?= esc($error) ?></li>
        <?php endforeach; ?>
    </ul>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (session()->has('error')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i><?= session('error') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Employee Form -->
<form action="<?= base_url('employees/store') ?>" method="post" enctype="multipart/form-data">
    <?= csrf_field() ?>

    <!-- Personal Information -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-id-card me-2"></i>Personal Information</h5>
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="employee_number" class="form-label">
                    Employee Number <span class="text-danger">*</span>
                    <?php if ($employeeNumberSettings['auto_generate']): ?>
                        <span class="badge bg-success ms-2">Auto-Generated</span>
                    <?php endif; ?>
                </label>
                <input type="text" class="form-control" id="employee_number" name="employee_number"
                       value="<?= old('employee_number', $nextEmployeeNumber ?? '') ?>"
                       <?= $employeeNumberSettings['auto_generate'] ? 'readonly' : 'required' ?>
                       placeholder="<?= $employeeNumberSettings['auto_generate'] ? 'Will be auto-generated' : 'Enter employee number' ?>">
                <?php if ($employeeNumberSettings['auto_generate']): ?>
                    <small class="text-muted">Next number: <?= esc($nextEmployeeNumber) ?></small>
                <?php endif; ?>
            </div>

            <div class="col-md-6 mb-3">
                <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                <select class="form-select" id="status" name="status" required>
                    <option value="active" <?= old('status', 'active') == 'active' ? 'selected' : '' ?>>Active</option>
                    <option value="inactive" <?= old('status') == 'inactive' ? 'selected' : '' ?>>Inactive</option>
                    <option value="resigned" <?= old('status') == 'resigned' ? 'selected' : '' ?>>Resigned</option>
                    <option value="terminated" <?= old('status') == 'terminated' ? 'selected' : '' ?>>Terminated</option>
                </select>
            </div>

            <div class="col-md-4 mb-3">
                <label for="first_name" class="form-label">First Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="first_name" name="first_name"
                       value="<?= old('first_name') ?>" required>
            </div>

            <div class="col-md-4 mb-3">
                <label for="middle_name" class="form-label">Middle Name</label>
                <input type="text" class="form-control" id="middle_name" name="middle_name"
                       value="<?= old('middle_name') ?>">
            </div>

            <div class="col-md-4 mb-3">
                <label for="last_name" class="form-label">Last Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="last_name" name="last_name"
                       value="<?= old('last_name') ?>" required>
            </div>

            <div class="col-md-6 mb-3">
                <label for="email" class="form-label">Email Address</label>
                <input type="email" class="form-control" id="email" name="email"
                       value="<?= old('email') ?>">
            </div>

            <div class="col-md-6 mb-3">
                <label for="phone" class="form-label">Phone Number</label>
                <input type="text" class="form-control" id="phone" name="phone"
                       value="<?= old('phone') ?>">
            </div>

            <div class="col-md-6 mb-3">
                <label for="date_of_birth" class="form-label">Date of Birth</label>
                <input type="date" class="form-control" id="date_of_birth" name="date_of_birth"
                       value="<?= old('date_of_birth') ?>">
            </div>

            <div class="col-md-6 mb-3">
                <label for="gender" class="form-label">Gender</label>
                <select class="form-select" id="gender" name="gender">
                    <option value="">Select Gender</option>
                    <option value="male" <?= old('gender') == 'male' ? 'selected' : '' ?>>Male</option>
                    <option value="female" <?= old('gender') == 'female' ? 'selected' : '' ?>>Female</option>
                    <option value="other" <?= old('gender') == 'other' ? 'selected' : '' ?>>Other</option>
                </select>
            </div>

            <div class="col-md-12 mb-3">
                <label for="photo" class="form-label">Photo</label>
                <input type="file" class="form-control" id="photo" name="photo" accept="image/*">
                <small class="text-muted">Accepted formats: JPG, PNG. Max size: 2MB</small>
            </div>
        </div>
    </div>

    <!-- Address Information -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-map-marker-alt me-2"></i>Address Information</h5>
        <div class="row">
            <div class="col-md-12 mb-3">
                <label for="address" class="form-label">Street Address</label>
                <input type="text" class="form-control" id="address" name="address"
                       value="<?= old('address') ?>">
            </div>

            <div class="col-md-4 mb-3">
                <label for="city" class="form-label">City</label>
                <input type="text" class="form-control" id="city" name="city"
                       value="<?= old('city') ?>">
            </div>

            <div class="col-md-4 mb-3">
                <label for="province" class="form-label">Province</label>
                <input type="text" class="form-control" id="province" name="province"
                       value="<?= old('province') ?>">
            </div>

            <div class="col-md-4 mb-3">
                <label for="zip_code" class="form-label">Zip Code</label>
                <input type="text" class="form-control" id="zip_code" name="zip_code"
                       value="<?= old('zip_code') ?>">
            </div>
        </div>
    </div>

    <!-- Employment Information -->
    <div class="table-card mb-4">
        <h5 class="mb-3"><i class="fas fa-briefcase me-2"></i>Employment Information</h5>
        <div class="row">
            <div class="col-md-6 mb-3">
                <label for="location_id" class="form-label">Location <span class="text-danger">*</span></label>
                <select class="form-select" id="location_id" name="location_id" required>
                    <option value="">Select Location</option>
                    <?php foreach ($locations as $location): ?>
                    <option value="<?= $location['id'] ?>" <?= old('location_id') == $location['id'] ? 'selected' : '' ?>>
                        <?= esc($location['name']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-6 mb-3">
                <label for="department_id" class="form-label">Department</label>
                <select class="form-select" id="department_id" name="department_id">
                    <option value="">Select Department</option>
                    <?php foreach ($departments as $department): ?>
                    <option value="<?= $department['id'] ?>" <?= old('department_id') == $department['id'] ? 'selected' : '' ?>>
                        <?= esc($department['name']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-6 mb-3">
                <label for="position" class="form-label">Position</label>
                <input type="text" class="form-control" id="position" name="position"
                       value="<?= old('position') ?>">
            </div>

            <div class="col-md-6 mb-3">
                <label for="employment_status" class="form-label">Employment Status</label>
                <select class="form-select" id="employment_status" name="employment_status">
                    <option value="">Select Status</option>
                    <option value="Full-time" <?= old('employment_status') == 'Full-time' ? 'selected' : '' ?>>Full-time</option>
                    <option value="Probationary" <?= old('employment_status', 'Probationary') == 'Probationary' ? 'selected' : '' ?>>Probationary</option>
                    <option value="Contractual" <?= old('employment_status') == 'Contractual' ? 'selected' : '' ?>>Contractual</option>
                    <option value="Part-time" <?= old('employment_status') == 'Part-time' ? 'selected' : '' ?>>Part-time</option>
                </select>
            </div>

            <div class="col-md-6 mb-3">
                <label for="hire_date" class="form-label">Hire Date <span class="text-danger">*</span></label>
                <input type="date" class="form-control" id="hire_date" name="hire_date"
                       value="<?= old('hire_date') ?>" required>
            </div>
        </div>
    </div>

    <!-- Form Actions -->
    <div class="d-flex justify-content-end gap-2">
        <a href="<?= base_url('employees') ?>" class="btn btn-secondary">
            <i class="fas fa-times"></i> Cancel
        </a>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Save Employee
        </button>
    </div>
</form>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
// Preview photo before upload
document.getElementById('photo').addEventListener('change', function(e) {
    const file = e.target.files[0];
    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            // You can add a preview image element here if needed
            console.log('Photo selected:', file.name);
        };
        reader.readAsDataURL(file);
    }
});
</script>
<?= $this->endSection() ?>
