<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<div class="row">
    <div class="col-md-4">
        <!-- Profile Card -->
        <div class="table-card text-center">
            <div class="mb-3">
                <img src="<?= user_avatar($user['photo']) ?>"
                     alt="Profile Photo"
                     class="rounded-circle"
                     style="width: 150px; height: 150px; object-fit: cover; border: 5px solid #f0f0f0;">
            </div>
            <h4><?= esc($user['full_name']) ?></h4>
            <p class="text-muted">@<?= esc($user['username']) ?></p>

            <div class="d-flex justify-content-center gap-3 mb-3">
                <div>
                    <div class="fw-bold text-primary"><?= esc($user['role_name'] ?? 'N/A') ?></div>
                    <div class="small text-muted">Role</div>
                </div>
                <div>
                    <div class="fw-bold text-success"><?= esc($user['status']) ?></div>
                    <div class="small text-muted">Status</div>
                </div>
            </div>

            <hr>

            <div class="text-start">
                <div class="mb-2">
                    <i class="fas fa-envelope text-muted me-2"></i>
                    <small><?= esc($user['email']) ?></small>
                </div>
                <?php if ($user['phone']): ?>
                <div class="mb-2">
                    <i class="fas fa-phone text-muted me-2"></i>
                    <small><?= esc($user['phone']) ?></small>
                </div>
                <?php endif; ?>
                <div class="mb-2">
                    <i class="fas fa-calendar text-muted me-2"></i>
                    <small>Joined <?= date('M d, Y', strtotime($user['created_at'])) ?></small>
                </div>
                <?php if ($user['last_login']): ?>
                <div class="mb-2">
                    <i class="fas fa-sign-in-alt text-muted me-2"></i>
                    <small>Last login: <?= date('M d, Y h:i A', strtotime($user['last_login'])) ?></small>
                </div>
                <?php endif; ?>
            </div>

            <hr>

            <a href="<?= base_url('change-password') ?>" class="btn btn-outline-primary w-100">
                <i class="fas fa-key me-2"></i>
                Change Password
            </a>
        </div>
    </div>

    <div class="col-md-8">
        <!-- Edit Profile Form -->
        <div class="table-card">
            <h5 class="mb-4">
                <i class="fas fa-user-edit me-2"></i>
                Edit Profile
            </h5>

            <form action="<?= base_url('profile/update') ?>" method="POST" enctype="multipart/form-data">
                <?= csrf_field() ?>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="username" class="form-label">Username</label>
                        <input type="text"
                               class="form-control"
                               id="username"
                               value="<?= esc($user['username']) ?>"
                               disabled>
                        <small class="text-muted">Username cannot be changed</small>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="full_name" class="form-label">Full Name <span class="text-danger">*</span></label>
                        <input type="text"
                               class="form-control <?= isset(session('errors')['full_name']) ? 'is-invalid' : '' ?>"
                               id="full_name"
                               name="full_name"
                               value="<?= old('full_name', $user['full_name']) ?>"
                               required>
                        <?php if (isset(session('errors')['full_name'])): ?>
                            <div class="invalid-feedback"><?= session('errors')['full_name'] ?></div>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
                        <input type="email"
                               class="form-control <?= isset(session('errors')['email']) ? 'is-invalid' : '' ?>"
                               id="email"
                               name="email"
                               value="<?= old('email', $user['email']) ?>"
                               required>
                        <?php if (isset(session('errors')['email'])): ?>
                            <div class="invalid-feedback"><?= session('errors')['email'] ?></div>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="phone" class="form-label">Phone Number</label>
                        <input type="text"
                               class="form-control <?= isset(session('errors')['phone']) ? 'is-invalid' : '' ?>"
                               id="phone"
                               name="phone"
                               value="<?= old('phone', $user['phone']) ?>"
                               placeholder="+63 XXX XXX XXXX">
                        <?php if (isset(session('errors')['phone'])): ?>
                            <div class="invalid-feedback"><?= session('errors')['phone'] ?></div>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-12 mb-3">
                        <label for="photo" class="form-label">Profile Photo</label>
                        <input type="file"
                               class="form-control <?= isset(session('errors')['photo']) ? 'is-invalid' : '' ?>"
                               id="photo"
                               name="photo"
                               accept="image/*">
                        <small class="text-muted">Accepted formats: JPG, PNG, GIF (Max 2MB)</small>
                        <?php if (isset(session('errors')['photo'])): ?>
                            <div class="invalid-feedback"><?= session('errors')['photo'] ?></div>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-12">
                        <hr>
                        <div class="d-flex justify-content-between">
                            <a href="<?= base_url('dashboard') ?>" class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left me-2"></i>
                                Back to Dashboard
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>
                                Update Profile
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Role & Permissions Info -->
        <div class="table-card mt-3">
            <h5 class="mb-4">
                <i class="fas fa-shield-alt me-2"></i>
                Role & Permissions
            </h5>

            <div class="mb-3">
                <strong>Role:</strong>
                <span class="badge bg-primary"><?= esc($user['role_name'] ?? 'N/A') ?></span>
            </div>

            <?php if (!empty($user['permissions'])): ?>
            <div>
                <strong>Permissions:</strong>
                <div class="mt-2">
                    <?php
                    $permissions = json_decode($user['permissions'], true) ?? [];
                    if (is_array($permissions)):
                        foreach ($permissions as $permission):
                    ?>
                        <span class="badge bg-secondary me-1 mb-1">
                            <?= esc(format_permission($permission)) ?>
                        </span>
                    <?php
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
            <?php endif; ?>

            <?php if (is_super_admin()): ?>
            <div class="alert alert-info mt-3 mb-0">
                <i class="fas fa-info-circle me-2"></i>
                <strong>Super Admin:</strong> You have full access to all system features and settings.
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?= $this->endSection() ?>
