<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Statistics Cards Row -->
<div class="row g-3 mb-4">
    <!-- Total Employees -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <i class="fas fa-users"></i>
            </div>
            <h6>Total Employees</h6>
            <div class="value"><?= number_format($totalEmployees) ?></div>
            <div class="change text-success">
                <i class="fas fa-arrow-up"></i>
                <?= $newEmployeesThisMonth ?> new this month
            </div>
        </div>
    </div>

    <!-- Present Today -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
                <i class="fas fa-check-circle"></i>
            </div>
            <h6>Present Today</h6>
            <div class="value"><?= number_format($presentCount) ?></div>
            <div class="change text-muted">
                <?= $activeEmployees > 0 ? round(($presentCount / $activeEmployees) * 100, 1) : 0 ?>% of active
            </div>
        </div>
    </div>

    <!-- Absent Today -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #ee0979 0%, #ff6a00 100%);">
                <i class="fas fa-times-circle"></i>
            </div>
            <h6>Absent Today</h6>
            <div class="value"><?= number_format($absentCount) ?></div>
            <div class="change text-muted">
                <?= $activeEmployees > 0 ? round(($absentCount / $activeEmployees) * 100, 1) : 0 ?>% of active
            </div>
        </div>
    </div>

    <!-- On Leave Today -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <i class="fas fa-calendar-alt"></i>
            </div>
            <h6>On Leave Today</h6>
            <div class="value"><?= number_format($onLeaveCount) ?></div>
            <div class="change text-warning">
                <i class="fas fa-clock"></i>
                <?= $pendingLeaveRequests ?> pending requests
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row g-3 my-4">
    <div class="col-md-12">
        <div class="table-card">
            <h5><i class="fas fa-bolt me-2"></i>Quick Actions</h5>
            <div class="row g-3">
                <?php if (has_permission('create-employee')): ?>
                <div class="col-md-3">
                    <a href="<?= base_url('employees/create') ?>" class="btn btn-outline-primary w-100">
                        <i class="fas fa-user-plus"></i>
                        Add New Employee
                    </a>
                </div>
                <?php endif; ?>

                <?php if (has_permission('record-attendance')): ?>
                <div class="col-md-3">
                    <a href="<?= base_url('attendance/manual-entry') ?>" class="btn btn-outline-success w-100">
                        <i class="fas fa-clock"></i>
                        Manual Attendance
                    </a>
                </div>
                <?php endif; ?>

                <?php if (has_permission('view-reports')): ?>
                <div class="col-md-3">
                    <a href="<?= base_url('reports/generate') ?>" class="btn btn-outline-info w-100">
                        <i class="fas fa-file-pdf"></i>
                        Generate Report
                    </a>
                </div>
                <?php endif; ?>

                <?php if (has_permission('view-settings')): ?>
                <div class="col-md-3">
                    <a href="<?= base_url('settings/system') ?>" class="btn btn-outline-secondary w-100">
                        <i class="fas fa-cog"></i>
                        System Settings
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row g-3 mb-4">
    <!-- Attendance Trends Chart -->
    <div class="col-md-8">
        <div class="table-card">
            <h5><i class="fas fa-chart-line me-2"></i>Attendance Trends (Last 7 Days)</h5>
            <canvas id="attendanceTrendsChart" height="80"></canvas>
        </div>
    </div>

    <!-- Today's Attendance Pie Chart -->
    <div class="col-md-4">
        <div class="table-card">
            <h5><i class="fas fa-chart-pie me-2"></i>Today's Status</h5>
            <canvas id="todayStatusChart"></canvas>
            <div class="mt-3">
                <div class="d-flex justify-content-between mb-2">
                    <span><i class="fas fa-circle text-success"></i> Present</span>
                    <strong><?= $presentCount ?></strong>
                </div>
                <div class="d-flex justify-content-between mb-2">
                    <span><i class="fas fa-circle text-danger"></i> Absent</span>
                    <strong><?= $absentCount ?></strong>
                </div>
                <div class="d-flex justify-content-between mb-2">
                    <span><i class="fas fa-circle text-warning"></i> Late</span>
                    <strong><?= $lateCount ?></strong>
                </div>
                <div class="d-flex justify-content-between">
                    <span><i class="fas fa-circle text-info"></i> On Leave</span>
                    <strong><?= $onLeaveCount ?></strong>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Department Breakdown and Recent Activities -->
<div class="row g-3">
    <!-- Department Breakdown -->
    <div class="col-md-6">
        <div class="table-card">
            <h5><i class="fas fa-building me-2"></i>Employees by Department</h5>
            <canvas id="departmentChart" height="200"></canvas>
        </div>
    </div>

    <!-- Recent Activities -->
    <div class="col-md-6">
        <div class="table-card">
            <h5><i class="fas fa-history me-2"></i>Recent Activities</h5>
            <div style="max-height: 400px; overflow-y: auto;">
                <?php if (!empty($recentActivities)): ?>
                    <?php foreach ($recentActivities as $activity): ?>
                    <div class="d-flex align-items-start mb-3 pb-3 border-bottom">
                        <div class="flex-shrink-0">
                            <div class="icon-circle" style="width: 40px; height: 40px; border-radius: 50%; background: #f0f0f0; display: flex; align-items: center; justify-content: center;">
                                <i class="fas fa-<?= $activity['action'] == 'create' ? 'plus' : ($activity['action'] == 'update' ? 'edit' : 'trash') ?> text-<?= $activity['action'] == 'create' ? 'success' : ($activity['action'] == 'update' ? 'primary' : 'danger') ?>"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="fw-bold"><?= esc($activity['full_name'] ?? $activity['username']) ?></div>
                            <div class="text-muted small">
                                <?= ucfirst($activity['action']) ?> <?= esc($activity['module']) ?>
                                <?php if ($activity['record_id']): ?>
                                    #<?= $activity['record_id'] ?>
                                <?php endif; ?>
                            </div>
                            <div class="text-muted small">
                                <i class="fas fa-clock"></i>
                                <?= date('M d, Y h:i A', strtotime($activity['created_at'])) ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-muted text-center py-4">No recent activities</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Attendance Trends Chart (Line Chart)
    const trendsCtx = document.getElementById('attendanceTrendsChart').getContext('2d');
    const attendanceTrendsChart = new Chart(trendsCtx, {
        type: 'line',
        data: {
            labels: <?= json_encode(array_column($attendanceTrends, 'date')) ?>,
            datasets: [
                {
                    label: 'Present',
                    data: <?= json_encode(array_column($attendanceTrends, 'present')) ?>,
                    borderColor: 'rgb(56, 239, 125)',
                    backgroundColor: 'rgba(56, 239, 125, 0.1)',
                    tension: 0.4,
                    fill: true
                },
                {
                    label: 'Absent',
                    data: <?= json_encode(array_column($attendanceTrends, 'absent')) ?>,
                    borderColor: 'rgb(238, 9, 121)',
                    backgroundColor: 'rgba(238, 9, 121, 0.1)',
                    tension: 0.4,
                    fill: true
                },
                {
                    label: 'Late',
                    data: <?= json_encode(array_column($attendanceTrends, 'late')) ?>,
                    borderColor: 'rgb(255, 193, 7)',
                    backgroundColor: 'rgba(255, 193, 7, 0.1)',
                    tension: 0.4,
                    fill: true
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    position: 'top',
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        precision: 0
                    }
                }
            }
        }
    });

    // Today's Status Pie Chart
    const statusCtx = document.getElementById('todayStatusChart').getContext('2d');
    const todayStatusChart = new Chart(statusCtx, {
        type: 'doughnut',
        data: {
            labels: ['Present', 'Absent', 'Late', 'On Leave'],
            datasets: [{
                data: [
                    <?= $attendanceByStatus['present'] ?>,
                    <?= $attendanceByStatus['absent'] ?>,
                    <?= $attendanceByStatus['late'] ?>,
                    <?= $attendanceByStatus['on_leave'] ?>
                ],
                backgroundColor: [
                    'rgb(56, 239, 125)',
                    'rgb(238, 9, 121)',
                    'rgb(255, 193, 7)',
                    'rgb(23, 162, 184)'
                ]
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: false
                }
            }
        }
    });

    // Department Breakdown Bar Chart
    const deptCtx = document.getElementById('departmentChart').getContext('2d');
    const departmentChart = new Chart(deptCtx, {
        type: 'bar',
        data: {
            labels: <?= json_encode(array_column($departmentBreakdown, 'department_name')) ?>,
            datasets: [{
                label: 'Employees',
                data: <?= json_encode(array_column($departmentBreakdown, 'count')) ?>,
                backgroundColor: 'rgba(102, 126, 234, 0.8)',
                borderColor: 'rgb(102, 126, 234)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        precision: 0
                    }
                }
            }
        }
    });
</script>
<?= $this->endSection() ?>
