<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="table-card">
            <div class="text-center mb-4">
                <div class="icon" style="width: 80px; height: 80px; margin: 0 auto; border-radius: 50%; background: var(--primary-gradient); display: flex; align-items: center; justify-content: center;">
                    <i class="fas fa-key fa-2x text-white"></i>
                </div>
                <h4 class="mt-3">Change Password</h4>
                <p class="text-muted">Update your account password</p>
            </div>

            <form action="<?= base_url('change-password') ?>" method="POST">
                <?= csrf_field() ?>

                <!-- Current Password -->
                <div class="mb-3">
                    <label for="current_password" class="form-label">
                        Current Password <span class="text-danger">*</span>
                    </label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-lock"></i>
                        </span>
                        <input type="password"
                               class="form-control <?= isset(session('errors')['current_password']) ? 'is-invalid' : '' ?>"
                               id="current_password"
                               name="current_password"
                               placeholder="Enter current password"
                               required
                               autofocus>
                        <?php if (isset(session('errors')['current_password'])): ?>
                            <div class="invalid-feedback"><?= session('errors')['current_password'] ?></div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- New Password -->
                <div class="mb-3">
                    <label for="new_password" class="form-label">
                        New Password <span class="text-danger">*</span>
                    </label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-key"></i>
                        </span>
                        <input type="password"
                               class="form-control <?= isset(session('errors')['new_password']) ? 'is-invalid' : '' ?>"
                               id="new_password"
                               name="new_password"
                               placeholder="Enter new password"
                               required
                               minlength="8"
                               oninput="checkPasswordStrength()">
                        <?php if (isset(session('errors')['new_password'])): ?>
                            <div class="invalid-feedback"><?= session('errors')['new_password'] ?></div>
                        <?php endif; ?>
                    </div>
                    <small class="text-muted">Minimum 8 characters</small>

                    <!-- Password Strength Indicator -->
                    <div id="passwordStrength" class="mt-2" style="display: none;">
                        <div class="progress" style="height: 5px;">
                            <div id="strengthBar" class="progress-bar" role="progressbar" style="width: 0%"></div>
                        </div>
                        <small id="strengthText" class="text-muted"></small>
                    </div>
                </div>

                <!-- Confirm New Password -->
                <div class="mb-3">
                    <label for="confirm_password" class="form-label">
                        Confirm New Password <span class="text-danger">*</span>
                    </label>
                    <div class="input-group">
                        <span class="input-group-text">
                            <i class="fas fa-check-circle"></i>
                        </span>
                        <input type="password"
                               class="form-control <?= isset(session('errors')['confirm_password']) ? 'is-invalid' : '' ?>"
                               id="confirm_password"
                               name="confirm_password"
                               placeholder="Confirm new password"
                               required
                               oninput="checkPasswordMatch()">
                        <?php if (isset(session('errors')['confirm_password'])): ?>
                            <div class="invalid-feedback"><?= session('errors')['confirm_password'] ?></div>
                        <?php endif; ?>
                    </div>
                    <small id="matchText" class="text-muted"></small>
                </div>

                <!-- Password Requirements -->
                <div class="alert alert-info">
                    <strong><i class="fas fa-info-circle me-2"></i>Password Requirements:</strong>
                    <ul class="mb-0 mt-2">
                        <li>At least 8 characters long</li>
                        <li>Mix of uppercase and lowercase letters (recommended)</li>
                        <li>Include numbers and special characters (recommended)</li>
                        <li>Different from your current password</li>
                    </ul>
                </div>

                <!-- Action Buttons -->
                <hr>
                <div class="d-flex justify-content-between">
                    <a href="<?= base_url('profile') ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-2"></i>
                        Back to Profile
                    </a>
                    <button type="submit" class="btn btn-primary" id="submitBtn" disabled>
                        <i class="fas fa-save me-2"></i>
                        Update Password
                    </button>
                </div>
            </form>
        </div>

        <!-- Security Tips -->
        <div class="table-card mt-3">
            <h6><i class="fas fa-shield-alt me-2"></i>Security Tips</h6>
            <ul class="mb-0">
                <li>Never share your password with anyone</li>
                <li>Use a unique password for this account</li>
                <li>Change your password regularly</li>
                <li>Avoid using easily guessable information</li>
                <li>Consider using a password manager</li>
            </ul>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function checkPasswordStrength() {
        const password = document.getElementById('new_password').value;
        const strengthDiv = document.getElementById('passwordStrength');
        const strengthBar = document.getElementById('strengthBar');
        const strengthText = document.getElementById('strengthText');

        if (password.length === 0) {
            strengthDiv.style.display = 'none';
            return;
        }

        strengthDiv.style.display = 'block';

        let strength = 0;
        let feedback = [];

        // Length check
        if (password.length >= 8) strength += 25;
        if (password.length >= 12) strength += 10;

        // Character variety checks
        if (/[a-z]/.test(password)) strength += 15;
        if (/[A-Z]/.test(password)) strength += 15;
        if (/[0-9]/.test(password)) strength += 15;
        if (/[^a-zA-Z0-9]/.test(password)) strength += 20;

        // Update progress bar
        strengthBar.style.width = strength + '%';

        // Set color and text based on strength
        if (strength < 40) {
            strengthBar.className = 'progress-bar bg-danger';
            strengthText.textContent = 'Weak password';
            strengthText.className = 'text-danger';
        } else if (strength < 70) {
            strengthBar.className = 'progress-bar bg-warning';
            strengthText.textContent = 'Medium strength';
            strengthText.className = 'text-warning';
        } else {
            strengthBar.className = 'progress-bar bg-success';
            strengthText.textContent = 'Strong password';
            strengthText.className = 'text-success';
        }

        checkPasswordMatch();
    }

    function checkPasswordMatch() {
        const newPassword = document.getElementById('new_password').value;
        const confirmPassword = document.getElementById('confirm_password').value;
        const matchText = document.getElementById('matchText');
        const submitBtn = document.getElementById('submitBtn');

        if (confirmPassword.length === 0) {
            matchText.textContent = '';
            submitBtn.disabled = true;
            return;
        }

        if (newPassword === confirmPassword) {
            matchText.innerHTML = '<i class="fas fa-check-circle text-success"></i> Passwords match';
            matchText.className = 'text-success';
            submitBtn.disabled = false;
        } else {
            matchText.innerHTML = '<i class="fas fa-times-circle text-danger"></i> Passwords do not match';
            matchText.className = 'text-danger';
            submitBtn.disabled = true;
        }
    }

    // Enable submit button only when passwords match
    document.getElementById('confirm_password').addEventListener('input', checkPasswordMatch);
</script>
<?= $this->endSection() ?>
