<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-calendar-day me-2"></i><?= esc($pageTitle) ?> - <?= date('M d, Y') ?></h2>
    <div>
        <a href="<?= base_url('attendance') ?>" class="btn btn-outline-secondary me-2">
            <i class="fas fa-history"></i> View History
        </a>

        <?php if (has_permission('manual-attendance')): ?>
        <a href="<?= base_url('attendance/manual-entry') ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Manual Entry
        </a>
        <?php endif; ?>
    </div>
</div>

<!-- Location and Department Filters (for admins/managers) -->
<?php if (is_super_admin() || count($locations) > 1): ?>
<div class="table-card mb-4">
    <form method="get" id="filterForm" class="row g-3 align-items-end">
        <div class="col-md-3">
            <label class="form-label"><i class="fas fa-map-marker-alt me-1"></i>Filter by Location</label>
            <select name="location_id" id="locationFilter" class="form-select">
                <option value="">All Locations</option>
                <?php foreach ($locations as $location): ?>
                <option value="<?= $location['id'] ?>" <?= ($selectedLocationId == $location['id']) ? 'selected' : '' ?>>
                    <?= esc($location['name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label"><i class="fas fa-building me-1"></i>Filter by Department</label>
            <select name="department_id" id="departmentFilter" class="form-select">
                <option value="">All Departments</option>
                <?php foreach ($departments as $dept): ?>
                <option value="<?= $dept['id'] ?>">
                    <?= esc($dept['name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label"><i class="fas fa-utensils me-1"></i>Lunch Status</label>
            <select name="lunch_status" id="lunchStatusFilter" class="form-select">
                <option value="">All</option>
                <option value="on_lunch">On Lunch</option>
                <option value="completed_lunch">Completed Lunch</option>
                <option value="not_on_lunch">Not On Lunch</option>
            </select>
        </div>
        <div class="col-md-3">
            <button type="button" onclick="applyFilters()" class="btn btn-primary w-100">
                <i class="fas fa-filter me-1"></i>Apply Filters
            </button>
        </div>
    </form>
</div>
<?php endif; ?>

<!-- Statistics Cards -->
<div class="row g-3 mb-4">
    <!-- Total Present -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);">
                <i class="fas fa-check-circle"></i>
            </div>
            <h6>Present Today</h6>
            <div class="value"><?= number_format($stats['present_count'] ?? 0) ?></div>
            <div class="change text-muted">
                <?= $totalEmployees > 0 ? round((($stats['present_count'] ?? 0) / $totalEmployees) * 100, 1) : 0 ?>% of total
            </div>
        </div>
    </div>

    <!-- Late Arrivals -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                <i class="fas fa-clock"></i>
            </div>
            <h6>Late Arrivals</h6>
            <div class="value"><?= number_format($stats['late_count'] ?? 0) ?></div>
            <div class="change text-warning">
                <?= number_format($stats['total_late_minutes'] ?? 0) ?> min total
            </div>
        </div>
    </div>

    <!-- Not Signed In -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #ee0979 0%, #ff6a00 100%);">
                <i class="fas fa-user-times"></i>
            </div>
            <h6>Not Signed In</h6>
            <div class="value"><?= number_format(count($notSignedIn)) ?></div>
            <div class="change text-muted">
                <?= $totalEmployees > 0 ? round((count($notSignedIn) / $totalEmployees) * 100, 1) : 0 ?>% of total
            </div>
        </div>
    </div>

    <!-- Avg Working Hours -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <i class="fas fa-business-time"></i>
            </div>
            <h6>Avg Working Hours</h6>
            <div class="value"><?= number_format($stats['avg_working_hours'] ?? 0, 1) ?></div>
            <div class="change text-muted">
                hours today
            </div>
        </div>
    </div>
</div>

<!-- Lunch Break Statistics -->
<div class="row g-3 mb-4">
    <!-- Currently On Lunch -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #fbc531 0%, #e58e26 100%);">
                <i class="fas fa-utensils"></i>
            </div>
            <h6>Currently On Lunch</h6>
            <div class="value"><?= number_format($lunchStats['on_lunch']) ?></div>
            <div class="change text-muted">
                <?= $lunchStats['total_signed_in'] > 0 ? round(($lunchStats['on_lunch'] / $lunchStats['total_signed_in']) * 100, 1) : 0 ?>% of signed in
            </div>
        </div>
    </div>

    <!-- Completed Lunch -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #4cd137 0%, #44bd32 100%);">
                <i class="fas fa-check-double"></i>
            </div>
            <h6>Completed Lunch</h6>
            <div class="value"><?= number_format($lunchStats['completed_lunch']) ?></div>
            <div class="change text-muted">
                <?= $lunchStats['total_signed_in'] > 0 ? round(($lunchStats['completed_lunch'] / $lunchStats['total_signed_in']) * 100, 1) : 0 ?>% of signed in
            </div>
        </div>
    </div>

    <!-- Not On Lunch -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #74b9ff 0%, #0984e3 100%);">
                <i class="fas fa-user-check"></i>
            </div>
            <h6>Not On Lunch</h6>
            <div class="value"><?= number_format($lunchStats['not_on_lunch']) ?></div>
            <div class="change text-muted">
                <?= $lunchStats['total_signed_in'] > 0 ? round(($lunchStats['not_on_lunch'] / $lunchStats['total_signed_in']) * 100, 1) : 0 ?>% of signed in
            </div>
        </div>
    </div>

    <!-- Total Signed In -->
    <div class="col-md-3">
        <div class="stat-card">
            <div class="icon" style="background: linear-gradient(135deg, #a29bfe 0%, #6c5ce7 100%);">
                <i class="fas fa-users"></i>
            </div>
            <h6>Total Signed In</h6>
            <div class="value"><?= number_format($lunchStats['total_signed_in']) ?></div>
            <div class="change text-muted">
                employees today
            </div>
        </div>
    </div>
</div>

<!-- Flash Messages -->
<?php if (session()->has('success')): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle me-2"></i><?= session('success') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<div class="row">
    <!-- Signed In Employees -->
    <div class="col-md-9">
        <div class="table-card">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0"><i class="fas fa-users me-2"></i>Signed In Employees (<?= count($attendance) ?>)</h5>
                <button id="bulkSignOutBtn" class="btn btn-danger btn-sm" style="display: none;" onclick="bulkSignOut()">
                    <i class="fas fa-sign-out-alt me-1"></i>Sign Out Selected (<span id="selectedCount">0</span>)
                </button>
            </div>
            <div class="table-responsive" style="max-height: 600px; overflow-y: auto;">
                <table class="table table-hover align-middle">
                    <thead class="sticky-top bg-white">
                        <tr>
                            <th style="width: 40px;">
                                <input type="checkbox" id="selectAll" class="form-check-input" title="Select All">
                            </th>
                            <th>Employee</th>
                            <?php if (!$selectedLocationId): ?>
                            <th>Location</th>
                            <?php endif; ?>
                            <th>Sign In</th>
                            <th>Lunch Break</th>
                            <th>Sign Out</th>
                            <th>Duration</th>
                            <th>Status</th>
                            <?php if (has_permission('manage-attendance')): ?>
                            <th>Actions</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody id="attendanceTableBody">
                        <?php if (!empty($attendance)): ?>
                            <?php foreach ($attendance as $record): ?>
                            <tr data-department-id="<?= $record['department_id'] ?? '' ?>"
                                data-lunch-out-time="<?= $record['lunch_out_time'] ? '1' : '' ?>"
                                data-lunch-in-time="<?= $record['lunch_in_time'] ? '1' : '' ?>"
                                data-sign-out-time="<?= $record['sign_out_time'] ? '1' : '' ?>">
                                <td>
                                    <?php if (!$record['sign_out_time']): ?>
                                    <input type="checkbox" class="form-check-input employee-checkbox"
                                           value="<?= $record['id'] ?>"
                                           data-employee-name="<?= esc($record['first_name'] . ' ' . $record['last_name']) ?>">
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <?php if (!empty($record['photo'])): ?>
                                        <img src="<?= base_url('uploads/employees/' . $record['photo']) ?>"
                                             alt="<?= esc($record['first_name']) ?>"
                                             class="rounded-circle me-2"
                                             style="width: 40px; height: 40px; object-fit: cover;">
                                        <?php else: ?>
                                        <div class="rounded-circle bg-secondary text-white d-flex align-items-center justify-content-center me-2"
                                             style="width: 40px; height: 40px;">
                                            <i class="fas fa-user"></i>
                                        </div>
                                        <?php endif; ?>
                                        <div>
                                            <strong><?= esc($record['first_name'] . ' ' . $record['last_name']) ?></strong>
                                            <br><small class="text-muted"><?= esc($record['department_name'] ?? 'N/A') ?></small>
                                        </div>
                                    </div>
                                </td>
                                <?php if (!$selectedLocationId): ?>
                                <td>
                                    <span class="badge bg-primary">
                                        <i class="fas fa-map-marker-alt"></i>
                                        <?= esc($record['location_name']) ?>
                                    </span>
                                </td>
                                <?php endif; ?>
                                <td>
                                    <span class="text-success">
                                        <i class="fas fa-sign-in-alt"></i>
                                        <?= date('h:i A', strtotime($record['sign_in_time'])) ?>
                                    </span>
                                    <br><small class="text-muted"><?= esc($record['sign_in_method']) ?></small>
                                </td>
                                <td>
                                    <?php if ($record['lunch_out_time'] && $record['lunch_in_time']): ?>
                                    <div>
                                        <small class="text-warning d-block">
                                            <i class="fas fa-utensils"></i> Out: <?= date('h:i A', strtotime($record['lunch_out_time'])) ?>
                                        </small>
                                        <small class="text-success d-block">
                                            <i class="fas fa-utensils"></i> In: <?= date('h:i A', strtotime($record['lunch_in_time'])) ?>
                                        </small>
                                        <small class="text-muted">(<?= $record['lunch_duration_minutes'] ?> min)</small>
                                    </div>
                                    <?php elseif ($record['lunch_out_time']): ?>
                                    <span class="badge bg-warning">On Lunch</span>
                                    <br><small><?= date('h:i A', strtotime($record['lunch_out_time'])) ?></small>
                                    <?php else: ?>
                                    <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($record['sign_out_time']): ?>
                                    <span class="text-danger">
                                        <i class="fas fa-sign-out-alt"></i>
                                        <?= date('h:i A', strtotime($record['sign_out_time'])) ?>
                                    </span>
                                    <?php else: ?>
                                    <span class="badge bg-info">Active</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($record['working_hours']): ?>
                                    <strong><?= number_format($record['working_hours'], 2) ?></strong> hrs
                                    <?php else: ?>
                                    <?php
                                    $signIn = strtotime($record['sign_in_time']);
                                    $duration = (time() - $signIn) / 3600;
                                    ?>
                                    <span class="text-muted"><?= number_format($duration, 1) ?> hrs</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                    $statusColors = [
                                        'Present' => 'success',
                                        'Late' => 'warning',
                                        'Absent' => 'danger',
                                        'On Leave' => 'info',
                                        'Half Day' => 'secondary',
                                        'Work From Home' => 'primary'
                                    ];
                                    $statusColor = $statusColors[$record['status']] ?? 'secondary';
                                    ?>
                                    <span class="badge bg-<?= $statusColor ?>">
                                        <?= esc($record['status']) ?>
                                    </span>
                                    <?php if ($record['is_late']): ?>
                                    <br><small class="text-danger">+<?= $record['late_minutes'] ?> min</small>
                                    <?php endif; ?>
                                </td>
                                <?php if (has_permission('manage-attendance')): ?>
                                <td>
                                    <?php if (!$record['sign_out_time']): ?>
                                        <?php if (!$record['lunch_out_time']): ?>
                                        <button onclick="recordLunch(<?= $record['id'] ?>, 'out')"
                                                class="btn btn-sm btn-outline-warning mb-1"
                                                title="Lunch Out">
                                            <i class="fas fa-utensils"></i> Out
                                        </button>
                                        <?php elseif (!$record['lunch_in_time']): ?>
                                        <button onclick="recordLunch(<?= $record['id'] ?>, 'in')"
                                                class="btn btn-sm btn-outline-success mb-1"
                                                title="Lunch In">
                                            <i class="fas fa-utensils"></i> In
                                        </button>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <?php endif; ?>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="<?= has_permission('manage-attendance') ? (!$selectedLocationId ? '9' : '8') : (!$selectedLocationId ? '8' : '7') ?>" class="text-center py-4 text-muted">
                                    No employees have signed in yet today
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Not Signed In -->
    <div class="col-md-3">
        <div class="table-card">
            <h5 class="mb-3"><i class="fas fa-user-clock me-2"></i>Not Signed In (<?= count($notSignedIn) ?>)</h5>
            <div style="max-height: 600px; overflow-y: auto;">
                <?php if (!empty($notSignedIn)): ?>
                    <?php foreach ($notSignedIn as $employee): ?>
                    <div class="d-flex align-items-center mb-3 pb-3 border-bottom">
                        <?php if (!empty($employee['photo'])): ?>
                        <img src="<?= base_url('uploads/employees/' . $employee['photo']) ?>"
                             alt="<?= esc($employee['first_name']) ?>"
                             class="rounded-circle me-3"
                             style="width: 45px; height: 45px; object-fit: cover;">
                        <?php else: ?>
                        <div class="rounded-circle bg-danger text-white d-flex align-items-center justify-content-center me-3"
                             style="width: 45px; height: 45px;">
                            <i class="fas fa-user"></i>
                        </div>
                        <?php endif; ?>
                        <div class="flex-grow-1">
                            <strong><?= esc($employee['first_name'] . ' ' . $employee['last_name']) ?></strong>
                            <br><small class="text-muted"><?= esc($employee['employee_number']) ?></small>
                            <?php if (!$selectedLocationId && !empty($employee['location_name'])): ?>
                            <br><small class="badge badge-sm bg-primary"><?= esc($employee['location_name']) ?></small>
                            <?php endif; ?>
                            <br><small class="text-muted"><?= esc($employee['department_name'] ?? 'N/A') ?></small>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="text-center py-5 text-success">
                        <i class="fas fa-check-circle fa-3x mb-3"></i>
                        <p class="mb-0">All employees have signed in!</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Handle "Select All" checkbox
    document.getElementById('selectAll').addEventListener('change', function() {
        const checkboxes = document.querySelectorAll('.employee-checkbox');
        checkboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
        updateBulkSignOutButton();
    });

    // Handle individual checkboxes
    document.querySelectorAll('.employee-checkbox').forEach(checkbox => {
        checkbox.addEventListener('change', function() {
            updateBulkSignOutButton();

            // Update "Select All" checkbox state
            const allCheckboxes = document.querySelectorAll('.employee-checkbox');
            const checkedCheckboxes = document.querySelectorAll('.employee-checkbox:checked');
            document.getElementById('selectAll').checked = allCheckboxes.length === checkedCheckboxes.length && allCheckboxes.length > 0;
        });
    });

    // Update bulk sign-out button visibility and count
    function updateBulkSignOutButton() {
        const checkedCheckboxes = document.querySelectorAll('.employee-checkbox:checked');
        const bulkBtn = document.getElementById('bulkSignOutBtn');
        const countSpan = document.getElementById('selectedCount');

        if (checkedCheckboxes.length > 0) {
            bulkBtn.style.display = 'block';
            countSpan.textContent = checkedCheckboxes.length;
        } else {
            bulkBtn.style.display = 'none';
        }
    }

    // Bulk sign-out function
    function bulkSignOut() {
        const checkedCheckboxes = document.querySelectorAll('.employee-checkbox:checked');

        if (checkedCheckboxes.length === 0) {
            alert('Please select at least one employee to sign out.');
            return;
        }

        // Get employee names for confirmation
        const employeeNames = Array.from(checkedCheckboxes)
            .map(cb => cb.dataset.employeeName)
            .join(', ');

        if (!confirm(`Are you sure you want to sign out ${checkedCheckboxes.length} employee(s)?\n\n${employeeNames}`)) {
            return;
        }

        // Get attendance IDs
        const attendanceIds = Array.from(checkedCheckboxes).map(cb => cb.value);

        // Show loading state
        const bulkBtn = document.getElementById('bulkSignOutBtn');
        const originalHtml = bulkBtn.innerHTML;
        bulkBtn.disabled = true;
        bulkBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Processing...';

        // Send request to server
        fetch('<?= base_url('attendance/bulk-sign-out') ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                attendance_ids: attendanceIds
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show success message
                alert(data.message);
                // Reload page to show updated data
                location.reload();
            } else {
                alert(data.message || 'Failed to sign out employees');
                bulkBtn.disabled = false;
                bulkBtn.innerHTML = originalHtml;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while signing out employees');
            bulkBtn.disabled = false;
            bulkBtn.innerHTML = originalHtml;
        });
    }

    // Lunch break recording function
    function recordLunch(attendanceId, type) {
        const action = type === 'out' ? 'Lunch Out' : 'Lunch In';
        const confirmMsg = type === 'out'
            ? 'Mark employee as going out for lunch?'
            : 'Mark employee as returning from lunch?';

        if (!confirm(confirmMsg)) {
            return;
        }

        // Show loading indicator
        const btn = event.target.closest('button');
        const originalHtml = btn.innerHTML;
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

        // Get CSRF token
        const csrfToken = '<?= csrf_hash() ?>';
        const csrfName = '<?= csrf_token() ?>';

        // Send request to server
        const url = type === 'out'
            ? '<?= base_url('attendance/lunch-out') ?>/' + attendanceId
            : '<?= base_url('attendance/lunch-in') ?>/' + attendanceId;

        fetch(url, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': csrfToken
            },
            body: JSON.stringify({
                [csrfName]: csrfToken
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show success message and reload
                alert(data.message);
                location.reload();
            } else {
                alert(data.message || `Failed to record ${action}`);
                btn.disabled = false;
                btn.innerHTML = originalHtml;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert(`An error occurred while recording ${action}`);
            btn.disabled = false;
            btn.innerHTML = originalHtml;
        });
    }

    // Filter functionality
    function applyFilters() {
        const departmentId = document.getElementById('departmentFilter').value;
        const lunchStatus = document.getElementById('lunchStatusFilter').value;

        const rows = document.querySelectorAll('#attendanceTableBody tr');
        let visibleCount = 0;

        rows.forEach(row => {
            let showRow = true;

            // Filter by department
            if (departmentId && row.dataset.departmentId !== departmentId) {
                showRow = false;
            }

            // Filter by lunch status
            if (lunchStatus) {
                const lunchOutTime = row.dataset.lunchOutTime;
                const lunchInTime = row.dataset.lunchInTime;
                const signOutTime = row.dataset.signOutTime;

                if (lunchStatus === 'on_lunch') {
                    // Currently on lunch (has lunch_out but no lunch_in)
                    if (!lunchOutTime || lunchInTime) {
                        showRow = false;
                    }
                } else if (lunchStatus === 'completed_lunch') {
                    // Completed lunch (has both lunch_out and lunch_in)
                    if (!lunchOutTime || !lunchInTime) {
                        showRow = false;
                    }
                } else if (lunchStatus === 'not_on_lunch') {
                    // Not on lunch (no lunch_out and not signed out)
                    if (lunchOutTime || signOutTime) {
                        showRow = false;
                    }
                }
            }

            // Show or hide row
            if (showRow) {
                row.style.display = '';
                visibleCount++;
            } else {
                row.style.display = 'none';
            }
        });

        // Update the count in the header
        const header = document.querySelector('.col-md-8 h5');
        if (header) {
            header.innerHTML = `<i class="fas fa-users me-2"></i>Signed In Employees (${visibleCount})`;
        }
    }

    // Location filter should reload the page (server-side filter)
    document.getElementById('locationFilter').addEventListener('change', function() {
        window.location.href = '<?= base_url('attendance/today') ?>?location_id=' + this.value;
    });

    // Reset filters when changing location
    document.getElementById('departmentFilter').value = '';
    document.getElementById('lunchStatusFilter').value = '';
</script>
<?= $this->endSection() ?>
