<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>

<!-- Header with Actions -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-clock me-2"></i><?= esc($pageTitle) ?></h2>
    <div>
        <a href="<?= base_url('attendance/today') ?>" class="btn btn-outline-primary me-2">
            <i class="fas fa-calendar-day"></i> Today's Attendance
        </a>

        <?php if (has_permission('manual-attendance')): ?>
        <a href="<?= base_url('attendance/manual-entry') ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Manual Entry
        </a>
        <?php endif; ?>
    </div>
</div>

<!-- Filters -->
<div class="table-card mb-4">
    <form method="get" action="<?= base_url('attendance') ?>" class="row g-3">
        <div class="col-md-2">
            <label class="form-label">Date From</label>
            <input type="date" name="date_from" class="form-control" value="<?= esc($filters['date_from']) ?>">
        </div>

        <div class="col-md-2">
            <label class="form-label">Date To</label>
            <input type="date" name="date_to" class="form-control" value="<?= esc($filters['date_to']) ?>">
        </div>

        <div class="col-md-2">
            <label class="form-label">Employee</label>
            <select name="employee_id" class="form-select">
                <option value="">All Employees</option>
                <?php foreach ($employees as $employee): ?>
                <option value="<?= $employee['employee_id'] ?>" <?= ($filters['employee_id'] ?? '') == $employee['employee_id'] ? 'selected' : '' ?>>
                    <?= esc($employee['first_name'] . ' ' . $employee['last_name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-2">
            <label class="form-label">Location</label>
            <select name="location_id" class="form-select">
                <option value="">All Locations</option>
                <?php foreach ($locations as $location): ?>
                <option value="<?= $location['id'] ?>" <?= ($filters['location_id'] ?? '') == $location['id'] ? 'selected' : '' ?>>
                    <?= esc($location['name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-2">
            <label class="form-label">Department</label>
            <select name="department_id" class="form-select">
                <option value="">All Departments</option>
                <?php foreach ($departments as $department): ?>
                <option value="<?= $department['id'] ?>" <?= ($filters['department_id'] ?? '') == $department['id'] ? 'selected' : '' ?>>
                    <?= esc($department['name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">
                <i class="fas fa-filter"></i> Filter
            </button>
        </div>
    </form>
</div>

<!-- Flash Messages -->
<?php if (session()->has('success')): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
    <i class="fas fa-check-circle me-2"></i><?= session('success') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<?php if (session()->has('error')): ?>
<div class="alert alert-danger alert-dismissible fade show" role="alert">
    <i class="fas fa-exclamation-circle me-2"></i><?= session('error') ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Attendance Table -->
<div class="table-card">
    <div class="table-responsive">
        <table class="table table-hover align-middle">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Employee</th>
                    <th>Department</th>
                    <th>Location</th>
                    <th>Sign In</th>
                    <th>Sign Out</th>
                    <th>Working Hours</th>
                    <th>Status</th>
                    <th>Method</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($attendance)): ?>
                    <?php foreach ($attendance as $record): ?>
                    <tr>
                        <td><?= date('M d, Y', strtotime($record['attendance_date'])) ?></td>
                        <td>
                            <div class="d-flex align-items-center">
                                <?php if (!empty($record['photo'])): ?>
                                <img src="<?= base_url('uploads/employees/' . $record['photo']) ?>"
                                     alt="<?= esc($record['first_name']) ?>"
                                     class="rounded-circle me-2"
                                     style="width: 32px; height: 32px; object-fit: cover;">
                                <?php endif; ?>
                                <div>
                                    <strong><?= esc($record['first_name'] . ' ' . $record['last_name']) ?></strong>
                                    <br><small class="text-muted"><?= esc($record['emp_id']) ?></small>
                                </div>
                            </div>
                        </td>
                        <td><?= esc($record['department_name'] ?? '-') ?></td>
                        <td><?= esc($record['location_name']) ?></td>
                        <td>
                            <?php if ($record['sign_in_time']): ?>
                            <span class="text-success">
                                <i class="fas fa-sign-in-alt"></i>
                                <?= date('h:i A', strtotime($record['sign_in_time'])) ?>
                            </span>
                            <?php else: ?>
                            <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($record['sign_out_time']): ?>
                            <span class="text-danger">
                                <i class="fas fa-sign-out-alt"></i>
                                <?= date('h:i A', strtotime($record['sign_out_time'])) ?>
                            </span>
                            <?php else: ?>
                            <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($record['working_hours']): ?>
                            <?= number_format($record['working_hours'], 2) ?> hrs
                            <?php else: ?>
                            <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php
                            $statusColors = [
                                'Present' => 'success',
                                'Late' => 'warning',
                                'Absent' => 'danger',
                                'On Leave' => 'info',
                                'Half Day' => 'secondary',
                                'Work From Home' => 'primary'
                            ];
                            $statusColor = $statusColors[$record['status']] ?? 'secondary';
                            ?>
                            <span class="badge bg-<?= $statusColor ?>">
                                <?= esc($record['status']) ?>
                            </span>
                            <?php if ($record['is_late']): ?>
                            <br><small class="text-danger">Late: <?= $record['late_minutes'] ?> min</small>
                            <?php endif; ?>
                        </td>
                        <td>
                            <small class="text-muted">
                                <?= esc($record['sign_in_method'] ?? 'Manual') ?>
                            </small>
                        </td>
                        <td>
                            <a href="<?= base_url('attendance/view/' . $record['id']) ?>"
                               class="btn btn-sm btn-outline-info"
                               title="View Details">
                                <i class="fas fa-eye"></i>
                            </a>

                            <?php if (!$record['sign_out_time'] && has_permission('manage-attendance')): ?>
                            <button onclick="manualSignOut(<?= $record['id'] ?>, '<?= esc($record['first_name'] . ' ' . $record['last_name']) ?>')"
                                    class="btn btn-sm btn-outline-danger"
                                    title="Manual Sign Out">
                                <i class="fas fa-sign-out-alt"></i>
                            </button>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="10" class="text-center py-5 text-muted">
                            <i class="fas fa-calendar-times fa-3x mb-3"></i>
                            <p>No attendance records found for the selected period</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <?php if (!empty($attendance)): ?>
    <div class="p-3 border-top">
        <div class="d-flex justify-content-between align-items-center">
            <div class="text-muted">
                Showing <?= count($attendance) ?> record(s)
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    function manualSignOut(attendanceId, employeeName) {
        if (!confirm(`Are you sure you want to manually sign out ${employeeName}?\n\nThis will record the current time as their sign-out time.`)) {
            return;
        }

        // Show loading indicator
        const btn = event.target.closest('button');
        const originalHtml = btn.innerHTML;
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';

        // Get CSRF token
        const csrfToken = '<?= csrf_hash() ?>';
        const csrfName = '<?= csrf_token() ?>';

        // Send request to server
        fetch(`<?= base_url('attendance/manual-sign-out') ?>/${attendanceId}`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': csrfToken
            },
            body: JSON.stringify({
                [csrfName]: csrfToken
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Show success message and reload
                alert(data.message);
                location.reload();
            } else {
                alert(data.message || 'Failed to sign out employee');
                btn.disabled = false;
                btn.innerHTML = originalHtml;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('An error occurred while signing out the employee');
            btn.disabled = false;
            btn.innerHTML = originalHtml;
        });
    }
</script>
<?= $this->endSection() ?>
