<?php

namespace App\Models;

use CodeIgniter\Model;

class PermissionModel extends Model
{
    protected $table            = 'permissions';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'name',
        'slug',
        'module',
        'description'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'name' => 'required|max_length[100]|is_unique[permissions.name,id,{id}]',
        'slug' => 'required|max_length[100]|is_unique[permissions.slug,id,{id}]|alpha_dash',
        'module' => 'permit_empty|max_length[50]',
    ];

    protected $validationMessages = [
        'name' => [
            'required'  => 'Permission name is required',
            'is_unique' => 'This permission name already exists',
        ],
        'slug' => [
            'required'   => 'Permission slug is required',
            'is_unique'  => 'This permission slug already exists',
            'alpha_dash' => 'Permission slug can only contain alphanumeric characters, underscores and dashes',
        ],
    ];

    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    /**
     * Get permissions grouped by module
     */
    public function getPermissionsByModule()
    {
        $permissions = $this->findAll();
        $grouped = [];

        foreach ($permissions as $permission) {
            $module = $permission['module'];
            if (!isset($grouped[$module])) {
                $grouped[$module] = [];
            }
            $grouped[$module][] = $permission;
        }

        return $grouped;
    }
}
