<?php

namespace App\Models;

use CodeIgniter\Model;

class LeaveTypeModel extends Model
{
    protected $table            = 'leave_types';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [
        'name',
        'code',
        'description',
        'days_per_year',
        'is_paid',
        'requires_document',
        'max_consecutive_days',
        'color',
        'is_active'
    ];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Validation
    protected $validationRules = [
        'name' => 'required|max_length[50]|is_unique[leave_types.name,id,{id}]',
        'code' => 'required|max_length[20]|is_unique[leave_types.code,id,{id}]',
    ];

    protected $validationMessages = [
        'name' => [
            'required'  => 'Leave type name is required',
            'is_unique' => 'This leave type name already exists',
        ],
    ];

    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    /**
     * Get active leave types
     */
    public function getActiveLeaveTypes()
    {
        return $this->where('is_active', 1)->findAll();
    }
}
