<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class LocationSeeder extends Seeder
{
    public function run()
    {
        $locations = [
            [
                'location_code'   => 'LBDI-HQ',
                'location_name'   => 'LBDI Head Office',
                'address'         => '123 Main Street',
                'city'            => 'Manila',
                'province'        => 'Metro Manila',
                'postal_code'     => '1000',
                'contact_person'  => 'Juan Dela Cruz',
                'contact_phone'   => '+63-2-1234-5678',
                'contact_email'   => 'headoffice@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-CEB',
                'location_name'   => 'LBDI Cebu Branch',
                'address'         => '456 Osmena Boulevard',
                'city'            => 'Cebu City',
                'province'        => 'Cebu',
                'postal_code'     => '6000',
                'contact_person'  => 'Maria Santos',
                'contact_phone'   => '+63-32-234-5678',
                'contact_email'   => 'cebu@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-DAV',
                'location_name'   => 'LBDI Davao Branch',
                'address'         => '789 J.P. Laurel Avenue',
                'city'            => 'Davao City',
                'province'        => 'Davao del Sur',
                'postal_code'     => '8000',
                'contact_person'  => 'Pedro Reyes',
                'contact_phone'   => '+63-82-345-6789',
                'contact_email'   => 'davao@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-BAG',
                'location_name'   => 'LBDI Baguio Branch',
                'address'         => '321 Session Road',
                'city'            => 'Baguio City',
                'province'        => 'Benguet',
                'postal_code'     => '2600',
                'contact_person'  => 'Ana Garcia',
                'contact_phone'   => '+63-74-456-7890',
                'contact_email'   => 'baguio@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-ILO',
                'location_name'   => 'LBDI Iloilo Branch',
                'address'         => '654 Rizal Street',
                'city'            => 'Iloilo City',
                'province'        => 'Iloilo',
                'postal_code'     => '5000',
                'contact_person'  => 'Carlos Martinez',
                'contact_phone'   => '+63-33-567-8901',
                'contact_email'   => 'iloilo@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-CDO',
                'location_name'   => 'LBDI Cagayan de Oro Branch',
                'address'         => '987 Corrales Avenue',
                'city'            => 'Cagayan de Oro',
                'province'        => 'Misamis Oriental',
                'postal_code'     => '9000',
                'contact_person'  => 'Rosa Fernandez',
                'contact_phone'   => '+63-88-678-9012',
                'contact_email'   => 'cdo@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-BAC',
                'location_name'   => 'LBDI Bacolod Branch',
                'address'         => '147 Lacson Street',
                'city'            => 'Bacolod City',
                'province'        => 'Negros Occidental',
                'postal_code'     => '6100',
                'contact_person'  => 'Luis Mendoza',
                'contact_phone'   => '+63-34-789-0123',
                'contact_email'   => 'bacolod@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-ZAM',
                'location_name'   => 'LBDI Zamboanga Branch',
                'address'         => '258 Veterans Avenue',
                'city'            => 'Zamboanga City',
                'province'        => 'Zamboanga del Sur',
                'postal_code'     => '7000',
                'contact_person'  => 'Elena Cruz',
                'contact_phone'   => '+63-62-890-1234',
                'contact_email'   => 'zamboanga@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-TAC',
                'location_name'   => 'LBDI Tacloban Branch',
                'address'         => '369 Real Street',
                'city'            => 'Tacloban City',
                'province'        => 'Leyte',
                'postal_code'     => '6500',
                'contact_person'  => 'Roberto Silva',
                'contact_phone'   => '+63-53-901-2345',
                'contact_email'   => 'tacloban@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-GEN',
                'location_name'   => 'LBDI General Santos Branch',
                'address'         => '741 Pioneer Avenue',
                'city'            => 'General Santos City',
                'province'        => 'South Cotabato',
                'postal_code'     => '9500',
                'contact_person'  => 'Carmen Lopez',
                'contact_phone'   => '+63-83-012-3456',
                'contact_email'   => 'gensan@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-DUM',
                'location_name'   => 'LBDI Dumaguete Branch',
                'address'         => '852 Perdices Street',
                'city'            => 'Dumaguete City',
                'province'        => 'Negros Oriental',
                'postal_code'     => '6200',
                'contact_person'  => 'Miguel Torres',
                'contact_phone'   => '+63-35-123-4567',
                'contact_email'   => 'dumaguete@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-BUT',
                'location_name'   => 'LBDI Butuan Branch',
                'address'         => '963 J.C. Aquino Avenue',
                'city'            => 'Butuan City',
                'province'        => 'Agusan del Norte',
                'postal_code'     => '8600',
                'contact_person'  => 'Sofia Ramos',
                'contact_phone'   => '+63-85-234-5678',
                'contact_email'   => 'butuan@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-LEG',
                'location_name'   => 'LBDI Legazpi Branch',
                'address'         => '159 Penaranda Street',
                'city'            => 'Legazpi City',
                'province'        => 'Albay',
                'postal_code'     => '4500',
                'contact_person'  => 'Antonio Morales',
                'contact_phone'   => '+63-52-345-6789',
                'contact_email'   => 'legazpi@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-NAG',
                'location_name'   => 'LBDI Naga Branch',
                'address'         => '753 Elias Angeles Street',
                'city'            => 'Naga City',
                'province'        => 'Camarines Sur',
                'postal_code'     => '4400',
                'contact_person'  => 'Isabel Castillo',
                'contact_phone'   => '+63-54-456-7890',
                'contact_email'   => 'naga@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-PUE',
                'location_name'   => 'LBDI Puerto Princesa Branch',
                'address'         => '357 Rizal Avenue',
                'city'            => 'Puerto Princesa',
                'province'        => 'Palawan',
                'postal_code'     => '5300',
                'contact_person'  => 'Gabriel Flores',
                'contact_phone'   => '+63-48-567-8901',
                'contact_email'   => 'palawan@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
            [
                'location_code'   => 'LBDI-ILI',
                'location_name'   => 'LBDI Iligan Branch',
                'address'         => '951 Quezon Avenue',
                'city'            => 'Iligan City',
                'province'        => 'Lanao del Norte',
                'postal_code'     => '9200',
                'contact_person'  => 'Patricia Gomez',
                'contact_phone'   => '+63-63-678-9012',
                'contact_email'   => 'iligan@lbdi.com',
                'timezone'        => 'Asia/Manila',
                'is_active'       => 1,
            ],
        ];

        foreach ($locations as &$location) {
            $location['created_at'] = date('Y-m-d H:i:s');
            $location['updated_at'] = date('Y-m-d H:i:s');
        }

        $this->db->table('locations')->insertBatch($locations);
    }
}
