<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddLocalUuidToAttendanceTable extends Migration
{
    public function up()
    {
        $fields = [
            'local_uuid' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'null'       => true,
                'unique'     => true,
                'comment'    => 'Unique identifier from mobile device for offline sync',
            ],
            'device_time' => [
                'type'    => 'DATETIME',
                'null'    => true,
                'comment' => 'Timestamp from mobile device when record was created',
            ],
        ];

        $this->forge->addColumn('attendance', $fields);

        // Create index on local_uuid for faster lookups
        $this->forge->addKey('local_uuid');
    }

    public function down()
    {
        $this->forge->dropColumn('attendance', ['local_uuid', 'device_time']);
    }
}
