<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddEmployeeIdToUsersTable extends Migration
{
    public function up()
    {
        $this->forge->addColumn('users', [
            'employee_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'unsigned'   => true,
                'null'       => true,
                'after'      => 'id',
            ],
        ]);

        // Add foreign key constraint
        $this->forge->processIndexes('users');
        $this->db->query('ALTER TABLE users ADD CONSTRAINT fk_users_employee_id FOREIGN KEY (employee_id) REFERENCES employees(id) ON DELETE SET NULL ON UPDATE CASCADE');

        // Add unique index to ensure one user per employee
        $this->db->query('ALTER TABLE users ADD UNIQUE KEY unique_employee_id (employee_id)');
    }

    public function down()
    {
        // Drop foreign key and unique constraint first
        $this->db->query('ALTER TABLE users DROP FOREIGN KEY fk_users_employee_id');
        $this->db->query('ALTER TABLE users DROP INDEX unique_employee_id');

        // Drop the column
        $this->forge->dropColumn('users', 'employee_id');
    }
}
